/*
 * Decompiled with CFR 0.152.
 */
package com.phidgets;

import com.phidgets.Phidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.BackEMFUpdateEvent;
import com.phidgets.event.BackEMFUpdateListener;
import com.phidgets.event.CurrentChangeEvent;
import com.phidgets.event.CurrentChangeListener;
import com.phidgets.event.CurrentUpdateEvent;
import com.phidgets.event.CurrentUpdateListener;
import com.phidgets.event.EncoderPositionChangeEvent;
import com.phidgets.event.EncoderPositionChangeListener;
import com.phidgets.event.EncoderPositionUpdateEvent;
import com.phidgets.event.EncoderPositionUpdateListener;
import com.phidgets.event.InputChangeEvent;
import com.phidgets.event.InputChangeListener;
import com.phidgets.event.MotorVelocityChangeEvent;
import com.phidgets.event.MotorVelocityChangeListener;
import com.phidgets.event.SensorUpdateEvent;
import com.phidgets.event.SensorUpdateListener;
import java.util.Iterator;
import java.util.LinkedList;

public final class MotorControlPhidget
extends Phidget {
    private LinkedList motorVelocityChangeListeners = new LinkedList();
    private long nativeMotorVelocityChangeHandler = 0L;
    private LinkedList currentChangeListeners = new LinkedList();
    private long nativeCurrentChangeHandler = 0L;
    private LinkedList currentUpdateListeners = new LinkedList();
    private long nativeCurrentUpdateHandler = 0L;
    private LinkedList inputChangeListeners = new LinkedList();
    private long nativeInputChangeHandler = 0L;
    private LinkedList encoderPositionChangeListeners = new LinkedList();
    private long nativeEncoderPositionChangeHandler = 0L;
    private LinkedList encoderPositionUpdateListeners = new LinkedList();
    private long nativeEncoderPositionUpdateHandler = 0L;
    private LinkedList backEMFUpdateListeners = new LinkedList();
    private long nativeBackEMFUpdateHandler = 0L;
    private LinkedList sensorUpdateListeners = new LinkedList();
    private long nativeSensorUpdateHandler = 0L;

    public MotorControlPhidget() throws PhidgetException {
        super(MotorControlPhidget.create());
    }

    private static native long create() throws PhidgetException;

    public native int getMotorCount() throws PhidgetException;

    public native int getInputCount() throws PhidgetException;

    public native int getEncoderCount() throws PhidgetException;

    public native int getSensorCount() throws PhidgetException;

    public native boolean getInputState(int var1) throws PhidgetException;

    public native int getEncoderPosition(int var1) throws PhidgetException;

    public native void setEncoderPosition(int var1, int var2) throws PhidgetException;

    public native int getSensorValue(int var1) throws PhidgetException;

    public native int getSensorRawValue(int var1) throws PhidgetException;

    public native boolean getRatiometric() throws PhidgetException;

    public native void setRatiometric(boolean var1) throws PhidgetException;

    public native double getAcceleration(int var1) throws PhidgetException;

    public native void setAcceleration(int var1, double var2) throws PhidgetException;

    public native double getAccelerationMax(int var1) throws PhidgetException;

    public native double getAccelerationMin(int var1) throws PhidgetException;

    public native double getVelocity(int var1) throws PhidgetException;

    public native double getSpeed(int var1) throws PhidgetException;

    public native void setVelocity(int var1, double var2) throws PhidgetException;

    public native void setSpeed(int var1, double var2) throws PhidgetException;

    public native double getCurrent(int var1) throws PhidgetException;

    public native boolean getBackEMFSensingState(int var1) throws PhidgetException;

    public native void setBackEMFSensingState(int var1, boolean var2) throws PhidgetException;

    public native double getBackEMF(int var1) throws PhidgetException;

    public native double getSupplyVoltage() throws PhidgetException;

    public native double getBraking(int var1) throws PhidgetException;

    public native void setBraking(int var1, double var2) throws PhidgetException;

    private final void enableDeviceSpecificEvents(boolean bl) {
        this.enableMotorVelocityChangeEvents(bl && this.motorVelocityChangeListeners.size() > 0);
        this.enableCurrentChangeEvents(bl && this.currentChangeListeners.size() > 0);
        this.enableCurrentUpdateEvents(bl && this.currentUpdateListeners.size() > 0);
        this.enableInputChangeEvents(bl && this.inputChangeListeners.size() > 0);
        this.enableEncoderPositionChangeEvents(bl && this.encoderPositionChangeListeners.size() > 0);
        this.enableEncoderPositionUpdateEvents(bl && this.encoderPositionUpdateListeners.size() > 0);
        this.enableBackEMFUpdateEvents(bl && this.backEMFUpdateListeners.size() > 0);
        this.enableSensorUpdateEvents(bl && this.sensorUpdateListeners.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addMotorVelocityChangeListener(MotorVelocityChangeListener motorVelocityChangeListener) {
        LinkedList linkedList = this.motorVelocityChangeListeners;
        synchronized (linkedList) {
            this.motorVelocityChangeListeners.add(motorVelocityChangeListener);
            this.enableMotorVelocityChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeMotorVelocityChangeListener(MotorVelocityChangeListener motorVelocityChangeListener) {
        LinkedList linkedList = this.motorVelocityChangeListeners;
        synchronized (linkedList) {
            this.motorVelocityChangeListeners.remove(motorVelocityChangeListener);
            this.enableMotorVelocityChangeEvents(this.motorVelocityChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMotorVelocityChange(MotorVelocityChangeEvent motorVelocityChangeEvent) {
        LinkedList linkedList = this.motorVelocityChangeListeners;
        synchronized (linkedList) {
            Iterator iterator = this.motorVelocityChangeListeners.iterator();
            while (iterator.hasNext()) {
                ((MotorVelocityChangeListener)iterator.next()).motorVelocityChanged(motorVelocityChangeEvent);
            }
        }
    }

    private native void enableMotorVelocityChangeEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addCurrentChangeListener(CurrentChangeListener currentChangeListener) {
        LinkedList linkedList = this.currentChangeListeners;
        synchronized (linkedList) {
            this.currentChangeListeners.add(currentChangeListener);
            this.enableCurrentChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeCurrentChangeListener(CurrentChangeListener currentChangeListener) {
        LinkedList linkedList = this.currentChangeListeners;
        synchronized (linkedList) {
            this.currentChangeListeners.remove(currentChangeListener);
            this.enableCurrentChangeEvents(this.currentChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCurrentChange(CurrentChangeEvent currentChangeEvent) {
        LinkedList linkedList = this.currentChangeListeners;
        synchronized (linkedList) {
            Iterator iterator = this.currentChangeListeners.iterator();
            while (iterator.hasNext()) {
                ((CurrentChangeListener)iterator.next()).currentChanged(currentChangeEvent);
            }
        }
    }

    private native void enableCurrentChangeEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addCurrentUpdateListener(CurrentUpdateListener currentUpdateListener) {
        LinkedList linkedList = this.currentUpdateListeners;
        synchronized (linkedList) {
            this.currentUpdateListeners.add(currentUpdateListener);
            this.enableCurrentUpdateEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeCurrentUpdateListener(CurrentUpdateListener currentUpdateListener) {
        LinkedList linkedList = this.currentUpdateListeners;
        synchronized (linkedList) {
            this.currentUpdateListeners.remove(currentUpdateListener);
            this.enableCurrentUpdateEvents(this.currentUpdateListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCurrentUpdate(CurrentUpdateEvent currentUpdateEvent) {
        LinkedList linkedList = this.currentUpdateListeners;
        synchronized (linkedList) {
            Iterator iterator = this.currentUpdateListeners.iterator();
            while (iterator.hasNext()) {
                ((CurrentUpdateListener)iterator.next()).currentUpdated(currentUpdateEvent);
            }
        }
    }

    private native void enableCurrentUpdateEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addInputChangeListener(InputChangeListener inputChangeListener) {
        LinkedList linkedList = this.inputChangeListeners;
        synchronized (linkedList) {
            this.inputChangeListeners.add(inputChangeListener);
            this.enableInputChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeInputChangeListener(InputChangeListener inputChangeListener) {
        LinkedList linkedList = this.inputChangeListeners;
        synchronized (linkedList) {
            this.inputChangeListeners.remove(inputChangeListener);
            this.enableInputChangeEvents(this.inputChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInputChange(InputChangeEvent inputChangeEvent) {
        LinkedList linkedList = this.inputChangeListeners;
        synchronized (linkedList) {
            Iterator iterator = this.inputChangeListeners.iterator();
            while (iterator.hasNext()) {
                ((InputChangeListener)iterator.next()).inputChanged(inputChangeEvent);
            }
        }
    }

    private native void enableInputChangeEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addEncoderPositionChangeListener(EncoderPositionChangeListener encoderPositionChangeListener) {
        LinkedList linkedList = this.encoderPositionChangeListeners;
        synchronized (linkedList) {
            this.encoderPositionChangeListeners.add(encoderPositionChangeListener);
            this.enableEncoderPositionChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeEncoderPositionChangeListener(EncoderPositionChangeListener encoderPositionChangeListener) {
        LinkedList linkedList = this.encoderPositionChangeListeners;
        synchronized (linkedList) {
            this.encoderPositionChangeListeners.remove(encoderPositionChangeListener);
            this.enableEncoderPositionChangeEvents(this.encoderPositionChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEncoderPositionChange(EncoderPositionChangeEvent encoderPositionChangeEvent) {
        LinkedList linkedList = this.encoderPositionChangeListeners;
        synchronized (linkedList) {
            Iterator iterator = this.encoderPositionChangeListeners.iterator();
            while (iterator.hasNext()) {
                ((EncoderPositionChangeListener)iterator.next()).encoderPositionChanged(encoderPositionChangeEvent);
            }
        }
    }

    private native void enableEncoderPositionChangeEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addEncoderPositionUpdateListener(EncoderPositionUpdateListener encoderPositionUpdateListener) {
        LinkedList linkedList = this.encoderPositionUpdateListeners;
        synchronized (linkedList) {
            this.encoderPositionUpdateListeners.add(encoderPositionUpdateListener);
            this.enableEncoderPositionUpdateEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeEncoderPositionUpdateListener(EncoderPositionUpdateListener encoderPositionUpdateListener) {
        LinkedList linkedList = this.encoderPositionUpdateListeners;
        synchronized (linkedList) {
            this.encoderPositionUpdateListeners.remove(encoderPositionUpdateListener);
            this.enableEncoderPositionUpdateEvents(this.encoderPositionUpdateListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEncoderPositionUpdate(EncoderPositionUpdateEvent encoderPositionUpdateEvent) {
        LinkedList linkedList = this.encoderPositionUpdateListeners;
        synchronized (linkedList) {
            Iterator iterator = this.encoderPositionUpdateListeners.iterator();
            while (iterator.hasNext()) {
                ((EncoderPositionUpdateListener)iterator.next()).encoderPositionUpdated(encoderPositionUpdateEvent);
            }
        }
    }

    private native void enableEncoderPositionUpdateEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addBackEMFUpdateListener(BackEMFUpdateListener backEMFUpdateListener) {
        LinkedList linkedList = this.backEMFUpdateListeners;
        synchronized (linkedList) {
            this.backEMFUpdateListeners.add(backEMFUpdateListener);
            this.enableBackEMFUpdateEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeBackEMFUpdateListener(BackEMFUpdateListener backEMFUpdateListener) {
        LinkedList linkedList = this.backEMFUpdateListeners;
        synchronized (linkedList) {
            this.backEMFUpdateListeners.remove(backEMFUpdateListener);
            this.enableBackEMFUpdateEvents(this.backEMFUpdateListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBackEMFUpdate(BackEMFUpdateEvent backEMFUpdateEvent) {
        LinkedList linkedList = this.backEMFUpdateListeners;
        synchronized (linkedList) {
            Iterator iterator = this.backEMFUpdateListeners.iterator();
            while (iterator.hasNext()) {
                ((BackEMFUpdateListener)iterator.next()).backEMFUpdated(backEMFUpdateEvent);
            }
        }
    }

    private native void enableBackEMFUpdateEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addSensorUpdateListener(SensorUpdateListener sensorUpdateListener) {
        LinkedList linkedList = this.sensorUpdateListeners;
        synchronized (linkedList) {
            this.sensorUpdateListeners.add(sensorUpdateListener);
            this.enableSensorUpdateEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeSensorUpdateListener(SensorUpdateListener sensorUpdateListener) {
        LinkedList linkedList = this.sensorUpdateListeners;
        synchronized (linkedList) {
            this.sensorUpdateListeners.remove(sensorUpdateListener);
            this.enableSensorUpdateEvents(this.sensorUpdateListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSensorUpdate(SensorUpdateEvent sensorUpdateEvent) {
        LinkedList linkedList = this.sensorUpdateListeners;
        synchronized (linkedList) {
            Iterator iterator = this.sensorUpdateListeners.iterator();
            while (iterator.hasNext()) {
                ((SensorUpdateListener)iterator.next()).sensorUpdated(sensorUpdateEvent);
            }
        }
    }

    private native void enableSensorUpdateEvents(boolean var1);
}

