/*
 * Decompiled with CFR 0.152.
 */
package com.phidgets;

import com.phidgets.Phidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.InputChangeEvent;
import com.phidgets.event.InputChangeListener;
import com.phidgets.event.OutputChangeEvent;
import com.phidgets.event.OutputChangeListener;
import com.phidgets.event.SensorChangeEvent;
import com.phidgets.event.SensorChangeListener;
import java.util.Iterator;
import java.util.LinkedList;

public final class InterfaceKitPhidget
extends Phidget {
    private LinkedList inputChangeListeners = new LinkedList();
    private long nativeInputChangeHandler = 0L;
    private LinkedList outputChangeListeners = new LinkedList();
    private long nativeOutputChangeHandler = 0L;
    private LinkedList sensorChangeListeners = new LinkedList();
    private long nativeSensorChangeHandler = 0L;

    public InterfaceKitPhidget() throws PhidgetException {
        super(InterfaceKitPhidget.create());
    }

    private static native long create() throws PhidgetException;

    public native int getOutputCount() throws PhidgetException;

    public native int getInputCount() throws PhidgetException;

    public native int getSensorCount() throws PhidgetException;

    public native int getDataRateMin(int var1) throws PhidgetException;

    public native int getDataRateMax(int var1) throws PhidgetException;

    public native boolean getInputState(int var1) throws PhidgetException;

    public native boolean getOutputState(int var1) throws PhidgetException;

    public native int getSensorValue(int var1) throws PhidgetException;

    public native int getSensorRawValue(int var1) throws PhidgetException;

    public native int getSensorChangeTrigger(int var1) throws PhidgetException;

    public native int getDataRate(int var1) throws PhidgetException;

    public native boolean getRatiometric() throws PhidgetException;

    public native void setOutputState(int var1, boolean var2) throws PhidgetException;

    public native void setSensorChangeTrigger(int var1, int var2) throws PhidgetException;

    public native void setDataRate(int var1, int var2) throws PhidgetException;

    public native void setRatiometric(boolean var1) throws PhidgetException;

    private final void enableDeviceSpecificEvents(boolean bl) {
        this.enableInputChangeEvents(bl && this.inputChangeListeners.size() > 0);
        this.enableOutputChangeEvents(bl && this.outputChangeListeners.size() > 0);
        this.enableSensorChangeEvents(bl && this.sensorChangeListeners.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addInputChangeListener(InputChangeListener inputChangeListener) {
        LinkedList linkedList = this.inputChangeListeners;
        synchronized (linkedList) {
            this.inputChangeListeners.add(inputChangeListener);
            this.enableInputChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeInputChangeListener(InputChangeListener inputChangeListener) {
        LinkedList linkedList = this.inputChangeListeners;
        synchronized (linkedList) {
            this.inputChangeListeners.remove(inputChangeListener);
            this.enableInputChangeEvents(this.inputChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInputChange(InputChangeEvent inputChangeEvent) {
        LinkedList linkedList = this.inputChangeListeners;
        synchronized (linkedList) {
            Iterator iterator = this.inputChangeListeners.iterator();
            while (iterator.hasNext()) {
                ((InputChangeListener)iterator.next()).inputChanged(inputChangeEvent);
            }
        }
    }

    private native void enableInputChangeEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addOutputChangeListener(OutputChangeListener outputChangeListener) {
        LinkedList linkedList = this.outputChangeListeners;
        synchronized (linkedList) {
            this.outputChangeListeners.add(outputChangeListener);
            this.enableOutputChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeOutputChangeListener(OutputChangeListener outputChangeListener) {
        LinkedList linkedList = this.outputChangeListeners;
        synchronized (linkedList) {
            this.outputChangeListeners.remove(outputChangeListener);
            this.enableOutputChangeEvents(this.outputChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireOutputChange(OutputChangeEvent outputChangeEvent) {
        LinkedList linkedList = this.outputChangeListeners;
        synchronized (linkedList) {
            Iterator iterator = this.outputChangeListeners.iterator();
            while (iterator.hasNext()) {
                ((OutputChangeListener)iterator.next()).outputChanged(outputChangeEvent);
            }
        }
    }

    private native void enableOutputChangeEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addSensorChangeListener(SensorChangeListener sensorChangeListener) {
        LinkedList linkedList = this.sensorChangeListeners;
        synchronized (linkedList) {
            this.sensorChangeListeners.add(sensorChangeListener);
            this.enableSensorChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeSensorChangeListener(SensorChangeListener sensorChangeListener) {
        LinkedList linkedList = this.sensorChangeListeners;
        synchronized (linkedList) {
            this.sensorChangeListeners.remove(sensorChangeListener);
            this.enableSensorChangeEvents(this.sensorChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSensorChange(SensorChangeEvent sensorChangeEvent) {
        LinkedList linkedList = this.sensorChangeListeners;
        synchronized (linkedList) {
            Iterator iterator = this.sensorChangeListeners.iterator();
            while (iterator.hasNext()) {
                ((SensorChangeListener)iterator.next()).sensorChanged(sensorChangeEvent);
            }
        }
    }

    private native void enableSensorChangeEvents(boolean var1);
}

