/*
 * Decompiled with CFR 0.152.
 */
package com.phidgets;

import com.phidgets.IRCode;
import com.phidgets.PhidgetException;

public final class IRCodeInfo {
    public static final int ENCODING_UNKNOWN = 1;
    public static final int ENCODING_SPACE = 2;
    public static final int ENCODING_PULSE = 3;
    public static final int ENCODING_BIPHASE = 4;
    public static final int ENCODING_RC5 = 5;
    public static final int ENCODING_RC6 = 6;
    public static final int LENGTH_UNKNOWN = 1;
    public static final int LENGTH_CONSTANT = 2;
    public static final int LENGTH_VARIABLE = 3;
    private int encoding = 1;
    private int length = 1;
    private int bitCount = 0;
    private int gap = 0;
    private int trail = 0;
    private int minRepeat = 1;
    private int carrierFrequency = 38000;
    private int dutyCycle = 33;
    private int[] header = null;
    private int[] one = new int[]{0, 0};
    private int[] zero = new int[]{0, 0};
    private int[] repeat = null;
    private IRCode toggleMask = null;

    public IRCodeInfo(int n) throws PhidgetException {
        this.bitCount = n;
    }

    public IRCodeInfo(int n, int n2) throws PhidgetException {
        this.encoding = n;
        this.bitCount = n2;
    }

    public IRCodeInfo(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int n3, int n4) throws PhidgetException {
        this.encoding = n;
        this.bitCount = n2;
        if (nArray != null) {
            if (nArray.length != 2) {
                throw new PhidgetException(4, "header must have 2 elements");
            }
            this.header = new int[]{nArray[0], nArray[1]};
        }
        if (nArray2 == null || nArray2.length != 2) {
            throw new PhidgetException(4, "zero must have 2 elements");
        }
        this.zero = new int[]{nArray2[0], nArray2[1]};
        if (nArray3 == null || nArray3.length != 2) {
            throw new PhidgetException(4, "one must have 2 elements");
        }
        this.one = new int[]{nArray3[0], nArray3[1]};
        this.trail = n3;
        this.gap = n4;
    }

    public IRCodeInfo(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int n3, int n4, int[] nArray4) throws PhidgetException {
        this.encoding = n;
        this.bitCount = n2;
        if (nArray != null) {
            if (nArray.length != 2) {
                throw new PhidgetException(4, "header must have 2 elements");
            }
            this.header = new int[]{nArray[0], nArray[1]};
        }
        if (nArray2 == null || nArray2.length != 2) {
            throw new PhidgetException(4, "zero must have 2 elements");
        }
        this.zero = new int[]{nArray2[0], nArray2[1]};
        if (nArray3 == null || nArray3.length != 2) {
            throw new PhidgetException(4, "one must have 2 elements");
        }
        this.one = new int[]{nArray3[0], nArray3[1]};
        this.trail = n3;
        this.gap = n4;
        if (nArray4 != null) {
            this.repeat = new int[nArray4.length];
            for (int i = 0; i < nArray4.length; ++i) {
                this.repeat[i] = nArray4[i];
            }
        }
    }

    public IRCodeInfo(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int n3, int n4, int[] nArray4, int n5, IRCode iRCode, int n6, int n7, int n8) throws PhidgetException {
        this.encoding = n;
        this.bitCount = n2;
        if (nArray != null) {
            if (nArray.length != 2) {
                throw new PhidgetException(4, "header must have 2 elements");
            }
            this.header = new int[]{nArray[0], nArray[1]};
        }
        if (nArray2 == null || nArray2.length != 2) {
            throw new PhidgetException(4, "zero must have 2 elements");
        }
        this.zero = new int[]{nArray2[0], nArray2[1]};
        if (nArray3 == null || nArray3.length != 2) {
            throw new PhidgetException(4, "one must have 2 elements");
        }
        this.one = new int[]{nArray3[0], nArray3[1]};
        this.trail = n3;
        this.gap = n4;
        if (nArray4 != null) {
            this.repeat = new int[nArray4.length];
            for (int i = 0; i < nArray4.length; ++i) {
                this.repeat[i] = nArray4[i];
            }
        }
        this.minRepeat = n5;
        if (iRCode != null) {
            iRCode = new IRCode(iRCode.getData(), iRCode.getBitCount());
        }
        this.length = n6;
        this.carrierFrequency = n7;
        this.dutyCycle = n8;
    }

    public int getEncoding() {
        return this.encoding;
    }

    public int getLength() {
        return this.length;
    }

    public int getBitCount() {
        return this.bitCount;
    }

    public int getGap() {
        return this.gap;
    }

    public int getTrail() {
        return this.trail;
    }

    public int getMinRepeat() {
        return this.minRepeat;
    }

    public int getCarrierFrequency() {
        return this.carrierFrequency;
    }

    public int getDutyCycle() {
        return this.dutyCycle;
    }

    public int[] getHeader() {
        return this.header;
    }

    public int[] getZero() {
        return this.zero;
    }

    public int[] getOne() {
        return this.one;
    }

    public int[] getRepeat() {
        return this.repeat;
    }

    public IRCode getToggleMask() {
        return this.toggleMask;
    }

    public String toString() {
        String string = "";
        string = string + "  Encoding: " + this.encoding + "\n";
        string = string + "  Zero: " + this.zero[0] + ", " + this.zero[1] + "\n";
        string = string + "  One: " + this.one[0] + ", " + this.one[1] + "\n";
        if (this.header != null && this.header[0] != 0) {
            string = string + "  Header: " + this.header[0] + ", " + this.header[1] + "\n";
        }
        if (this.trail != 0) {
            string = string + "  Trail: " + this.trail + "\n";
        }
        if (this.gap != 0) {
            string = string + "  Gap: " + this.gap + "\n";
        }
        if (this.repeat != null) {
            string = string + "  Repeat: ";
            for (int i = 0; i < this.repeat.length; ++i) {
                string = string + this.repeat[i] + ", ";
            }
            string = string + "\n";
        }
        return string;
    }
}

