/*
 * Decompiled with CFR 0.152.
 */
package com.phidgets;

import com.phidgets.Phidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.TemperatureChangeEvent;
import com.phidgets.event.TemperatureChangeListener;
import java.util.Iterator;
import java.util.LinkedList;

public final class TemperatureSensorPhidget
extends Phidget {
    public static final int PHIDGET_TEMPERATURE_SENSOR_K_TYPE = 1;
    public static final int PHIDGET_TEMPERATURE_SENSOR_J_TYPE = 2;
    public static final int PHIDGET_TEMPERATURE_SENSOR_E_TYPE = 3;
    public static final int PHIDGET_TEMPERATURE_SENSOR_T_TYPE = 4;
    private LinkedList temperatureChangeListeners = new LinkedList();
    private long nativeTemperatureChangeHandler = 0L;

    public TemperatureSensorPhidget() throws PhidgetException {
        super(TemperatureSensorPhidget.create());
    }

    private static native long create() throws PhidgetException;

    public native int getTemperatureInputCount() throws PhidgetException;

    public native int getSensorCount() throws PhidgetException;

    public native double getTemperature(int var1) throws PhidgetException;

    public native double getTemperatureMax(int var1) throws PhidgetException;

    public native double getTemperatureMin(int var1) throws PhidgetException;

    public native double getAmbientTemperature() throws PhidgetException;

    public native double getAmbientTemperatureMax() throws PhidgetException;

    public native double getAmbientTemperatureMin() throws PhidgetException;

    public native double getPotential(int var1) throws PhidgetException;

    public native double getPotentialMax(int var1) throws PhidgetException;

    public native double getPotentialMin(int var1) throws PhidgetException;

    public native void setTemperatureChangeTrigger(int var1, double var2) throws PhidgetException;

    public native double getTemperatureChangeTrigger(int var1) throws PhidgetException;

    public native int getThermocoupleType(int var1) throws PhidgetException;

    public native void setThermocoupleType(int var1, int var2) throws PhidgetException;

    private final void enableDeviceSpecificEvents(boolean bl) {
        this.enableTemperatureChangeEvents(bl && this.temperatureChangeListeners.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTemperatureChangeListener(TemperatureChangeListener temperatureChangeListener) {
        LinkedList linkedList = this.temperatureChangeListeners;
        synchronized (linkedList) {
            this.temperatureChangeListeners.add(temperatureChangeListener);
            this.enableTemperatureChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeTemperatureChangeListener(TemperatureChangeListener temperatureChangeListener) {
        LinkedList linkedList = this.temperatureChangeListeners;
        synchronized (linkedList) {
            this.temperatureChangeListeners.remove(temperatureChangeListener);
            this.enableTemperatureChangeEvents(this.temperatureChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTemperatureChange(TemperatureChangeEvent temperatureChangeEvent) {
        LinkedList linkedList = this.temperatureChangeListeners;
        synchronized (linkedList) {
            Iterator iterator = this.temperatureChangeListeners.iterator();
            while (iterator.hasNext()) {
                ((TemperatureChangeListener)iterator.next()).temperatureChanged(temperatureChangeEvent);
            }
        }
    }

    private native void enableTemperatureChangeEvents(boolean var1);
}

