/*
 * Decompiled with CFR 0.152.
 */
package com.phidgets;

import com.phidgets.IRCode;
import com.phidgets.IRCodeInfo;
import com.phidgets.IRLearnedCode;
import com.phidgets.Phidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.CodeEvent;
import com.phidgets.event.CodeListener;
import com.phidgets.event.LearnEvent;
import com.phidgets.event.LearnListener;
import com.phidgets.event.RawDataEvent;
import com.phidgets.event.RawDataListener;
import java.util.Iterator;
import java.util.LinkedList;

public final class IRPhidget
extends Phidget {
    public static final int RAWDATA_LONGSPACE = Integer.MAX_VALUE;
    private LinkedList codeListeners = new LinkedList();
    private long nativeCodeHandler = 0L;
    private LinkedList learnListeners = new LinkedList();
    private long nativeLearnHandler = 0L;
    private LinkedList rawDataListeners = new LinkedList();
    private long nativeRawDataHandler = 0L;

    public IRPhidget() throws PhidgetException {
        super(IRPhidget.create());
    }

    private static native long create() throws PhidgetException;

    public native void transmit(IRCode var1, IRCodeInfo var2) throws PhidgetException;

    public native void transmitRepeat() throws PhidgetException;

    public native void transmitRaw(int[] var1, int var2, int var3, int var4, int var5, int var6) throws PhidgetException;

    public final void transmitRaw(int[] nArray) throws PhidgetException {
        this.transmitRaw(nArray, 0, nArray.length, 0, 0, 0);
    }

    public final void transmitRaw(int[] nArray, int n) throws PhidgetException {
        this.transmitRaw(nArray, 0, nArray.length, n, 0, 0);
    }

    public final void transmitRaw(int[] nArray, int n, int n2) throws PhidgetException {
        this.transmitRaw(nArray, n, n2, 0, 0, 0);
    }

    public final void transmitRaw(int[] nArray, int n, int n2, int n3) throws PhidgetException {
        this.transmitRaw(nArray, n, n2, n3, 0, 0);
    }

    public native int readRaw(int[] var1, int var2, int var3) throws PhidgetException;

    public final int readRaw(int[] nArray) throws PhidgetException {
        return this.readRaw(nArray, 0, nArray.length);
    }

    public native IRCode getLastCode() throws PhidgetException;

    public native IRLearnedCode getLastLearnedCode() throws PhidgetException;

    private final void enableDeviceSpecificEvents(boolean bl) {
        this.enableCodeEvents(bl && this.codeListeners.size() > 0);
        this.enableLearnEvents(bl && this.learnListeners.size() > 0);
        this.enableRawDataEvents(bl && this.rawDataListeners.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addCodeListener(CodeListener codeListener) {
        LinkedList linkedList = this.codeListeners;
        synchronized (linkedList) {
            this.codeListeners.add(codeListener);
            this.enableCodeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeCodeListener(CodeListener codeListener) {
        LinkedList linkedList = this.codeListeners;
        synchronized (linkedList) {
            this.codeListeners.remove(codeListener);
            this.enableCodeEvents(this.codeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCode(CodeEvent codeEvent) {
        LinkedList linkedList = this.codeListeners;
        synchronized (linkedList) {
            Iterator iterator = this.codeListeners.iterator();
            while (iterator.hasNext()) {
                ((CodeListener)iterator.next()).code(codeEvent);
            }
        }
    }

    private native void enableCodeEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addLearnListener(LearnListener learnListener) {
        LinkedList linkedList = this.learnListeners;
        synchronized (linkedList) {
            this.learnListeners.add(learnListener);
            this.enableLearnEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeLearnListener(LearnListener learnListener) {
        LinkedList linkedList = this.learnListeners;
        synchronized (linkedList) {
            this.learnListeners.remove(learnListener);
            this.enableLearnEvents(this.learnListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLearn(LearnEvent learnEvent) {
        LinkedList linkedList = this.learnListeners;
        synchronized (linkedList) {
            Iterator iterator = this.learnListeners.iterator();
            while (iterator.hasNext()) {
                ((LearnListener)iterator.next()).learn(learnEvent);
            }
        }
    }

    private native void enableLearnEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addRawDataListener(RawDataListener rawDataListener) {
        LinkedList linkedList = this.rawDataListeners;
        synchronized (linkedList) {
            this.rawDataListeners.add(rawDataListener);
            this.enableRawDataEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeRawDataListener(RawDataListener rawDataListener) {
        LinkedList linkedList = this.rawDataListeners;
        synchronized (linkedList) {
            this.rawDataListeners.remove(rawDataListener);
            this.enableRawDataEvents(this.rawDataListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRawData(RawDataEvent rawDataEvent) {
        LinkedList linkedList = this.rawDataListeners;
        synchronized (linkedList) {
            Iterator iterator = this.rawDataListeners.iterator();
            while (iterator.hasNext()) {
                ((RawDataListener)iterator.next()).rawData(rawDataEvent);
            }
        }
    }

    private native void enableRawDataEvents(boolean var1);
}

