"""Copyright 2008 Phidgets Inc.
This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
"""

__author__ = 'Adam Stelmack'
__version__ = '2.1.6'
__date__ = 'April 7 2009'

from threading import *
import sys

class AttachEventArgs:
    """Attach event data and information will be stored in this class.
    
    The data stored in this event args class is a reference to the Phidget object that triggered the event.
    
    Properties:
        device<object>: Reference to the Phidget object from which this event originated
    """
    def __init__(self, device):
        self.device = device

class DetachEventArgs:
    """Detach event data and information will be stored in this class.
    
    The data stored in this event args class is a reference to the Phidget object that triggered the event.
    
    Properties:
        device<object>: Reference to the Phidget object from which this event originated
    """
    def __init__(self, device):
        self.device = device

class ServerConnectArgs:
    """Server connect event data and information will be stored in this class.
    
    The data stored in this event args class is a reference to the Phidget, or Dictionary, or Manager object that triggered the event.
    
    Properties:
        device<object>: Reference to the Phidget, or Dictionary, or Manager object from which this event originated
    """
    def __init__(self, device):
        self.device = device

class ServerDisconnectArgs:
    """Server Disconnect event data and information will be stored in this class.
    
    The data stored in this event args class is a reference to the Phidget, or Dictionary, or Manager object that triggered the event.
    
    Properties:
        device<object>: Reference to the Phidget, or Dictionary, or Manager object from which this event originated
    """
    def __init__(self, device):
        self.device = device

class ErrorEventArgs:
    """Error event data and information will be stored in this class.
    
    The data stored in this event args class is the error description and the error code.
    
    Properties:
        description<string>:  The reference to the error description string generated by the event. 
        eCode<int>: The reference to the error code value generated by the event.
    """
    def __init__(self, description, eCode):
        self.description = description
        self.eCode = eCode

class SensorChangeEventArgs:
    """Analog Sensor Change Event data and information will be stored in this class.
    
    Data specific to this event args class are the index of the analog sensor input that is changing and the sensor value read.
    
    Properties:
        index<int>: The reference to the analog sensor input index from which this event originated.
        value<int>: The reference to the value of the sensor.
    """
    def __init__(self, index, value):
        self.index = index
        self.value = value

class InputChangeEventArgs:
    """Input Change Event data and information will be stored in this class.
    
    Data specific to this event args class are the index of the digital input that is changing and the state value read.
    
    Properties:
        index<int>: The reference to the digital input index from which this event originated.
        value<int>: The reference to the bool state value that was read to generate the event.
    """
    def __init__(self, index, state):
        self.index = index
        self.state = state

class OutputChangeEventArgs:
    """Output Change Event data and information will be stored in this class.
    
    Data specific to this event args class are the index of the digital output that is changing and the state value read.
    
    Properties:
        index<int>: The reference to the index of the output.
        value<int>: The reference to the state of the output.
    """
    def __init__(self, index, state):
        self.index = index
        self.state = state

class EncoderPositionChangeEventArgs:
    """Encoder Position Change Event data and information will be stored in this class.
    
    Data specific to this event args class are the index of the encoder that is changing, the position change value read,
    and the elapsed time between position changes.
    
    Properties:
        index<int>:  The reference to the encoder index from which this event originated. 
        time<int>: The reference to the elapsed time between change events.
        positionChange<int>: The reference to the position change value that was read to generate the event.
    """
    def __init__(self, index, time, positionChange):
        self.index = index
        self.time = time
        self.positionChange = positionChange

class AccelerationChangeEventArgs:
    """Acceleration Change Event data and information will be stored in this class.
    
    Data specific to this event args class are the index of the axis that is changing and the acceleration value read.
    
    Properties:
        index<int>: The reference to the axis index from which this event originated.
        acceleration<double>: The reference to the acceleration value that was read to generate the event.
    """
    def __init__(self, index, acceleration):
        self.index = index
        self.acceleration = acceleration

class VelocityChangeEventArgs:
    """Velocity Change Event data and information will be stored in this class.
    
    Data specific to this event args class are the index of the motor whose velocity is changing and the velocity value read.
    
    Properties:
        index<int>:  The reference to the index of the motor.
        velocity<double>: The reference to the velocity of the motor.
    """
    def __init__(self, index, velocity):
        self.index = index
        self.velocity = velocity

class CurrentChangeEventArgs:
    """Current Change Event data and information will be stored in this class.
    
    Data specific to this event args class are the index of the motor whose current draw is changing and the current value read.
    
    Properties:
        index<int>: The reference to the index of the motor.
        current<double>: The reference the current of the motor.
    """
    def __init__(self, index, current):
        self.index = index
        self.current = current

class PositionChangeEventArgs:
    """Servo Position Change Event data and information will be stored in this class.
    
    Data specific to this event args class are the index of the motor whose position is changing and the position value read.
    
    Properties:
        index<int>: The reference to the index of the motor.
        position<double>: The reference to the position of the servo motor.
    """
    def __init__(self, index, position):
        self.index = index
        self.position = position

class StepperPositionChangeEventArgs:
    """Stepper Position Change Event data and information will be stored in this class.
    
    Data specific to this event args class are the index of the stepper motor whose position is changing and the position value read.
    
    Properties:
        index<int>: The reference to the index of the stepper motor.
        position<double>: The reference to the position of the stepper motor.
    """
    def __init__(self, index, position):
        self.index = index
        self.position = position

class PHChangeEventArgs:
    """PH Change Event data and information will be stored in this class.
    
    Data specific to this event args class is the PH value read.
    
    Properties:
        PH<double>: The reference pH value.
    """
    def __init__(self, PH):
        self.PH = PH

class TagEventArgs:
    """Tag Event data and information will be stored in this class.
    
    Data specific to this event args class is the Tag data that is read.
    
    Properties:
        tag<string>: The reference to the gained or lost tag.
    """
    def __init__(self, tag):
        self.tag = tag

class TemperatureChangeEventArgs:
    """Temperature Change Event data and information will be stored in this class.
    
    Data specific to this event args class is the index of the temperature sensor and the temperature data.
    
    Properties:
        index<int>: The reference to the index of the sensor.
        temperature<double>: The reference to the temperature of the sensor.
        potential<double>: The reference to the potential of the sensor.
    """
    def __init__(self, index, temperature, potential):
        self.index = index
        self.temperature = temperature
        self.potential = potential

class KeyChangeEventArgs:
    """Key Event data and information will be stored in this class.
    
    Data specific to this event args class is the value data and the key.
    
    Properties:
        key<string>: The Key that is changing in the Dictionary.
        value<string>: The value data that is being associated with that key in the Dictionary.
    """
    def __init__(self, key, value, reason):
        self.key = key
        self.value = value
        self.reason = reason
