/* PhidgetWeightSensorController */

#import <Cocoa/Cocoa.h>
#import <Phidget21/phidget21.h>

@interface PhidgetWeightSensorController : NSObject
{
    IBOutlet id connectedField;
    IBOutlet id serialField;
    IBOutlet id versionField;
    IBOutlet id weightField;
    IBOutlet id weightSlider;
	IBOutlet id mainWindow;
	IBOutlet NSImageView *pictureBox;
    IBOutlet NSBox *sensorBox;
    IBOutlet NSBox *settingsBox;
    IBOutlet id triggerField;
	
	IBOutlet NSPanel *errorEventLogWindow;
	IBOutlet NSTextView *errorEventLog;
	IBOutlet NSTextField *errorEventLogCounter;
	IBOutlet NSPanel *passwordPanel;
	IBOutlet NSTextField *passwordField;
}
- (void)openCmdLine;

- (IBAction)clearErrorLog:(id)sender;
- (IBAction)passwordOK:(id)sender;
- (IBAction)passwordCancel:(id)sender;

- (IBAction)setChangeTrigger:(id)sender;
- (void)phidgetAdded;
- (void)phidgetRemoved;
- (void)gotWeightChange:(double)Weight;
- (void)setPicture:(int)version:(CPhidget_DeviceID)devid;
@end
