/* PhidgetTextLEDController */

#import <Cocoa/Cocoa.h>
#import <Phidget21/phidget21.h>

@interface PhidgetTextLEDController : NSObject
{
    IBOutlet NSTextField *connectedField;
    IBOutlet NSTextField *row1Box;
    IBOutlet NSTextField *row2Box;
    IBOutlet NSTextField *row3Box;
    IBOutlet NSTextField *row4Box;
    IBOutlet NSTextField *row1Label;
    IBOutlet NSTextField *row2Label;
    IBOutlet NSTextField *row3Label;
    IBOutlet NSTextField *row4Label;
    IBOutlet NSTextField *serialField;
    IBOutlet NSTextField *versionField;
    IBOutlet NSTextField *brightnessField;
    IBOutlet NSTextField *numRowsField;
    IBOutlet NSTextField *numColsField;
	IBOutlet NSImageView *pictureBox;
    IBOutlet NSBox *settingsBox;
    IBOutlet NSBox *displayBox;
	IBOutlet id mainWindow;
	
	IBOutlet NSPanel *errorEventLogWindow;
	IBOutlet NSTextView *errorEventLog;
	IBOutlet NSTextField *errorEventLogCounter;
	IBOutlet NSPanel *passwordPanel;
	IBOutlet NSTextField *passwordField;
}
- (void)openCmdLine;

- (IBAction)clearErrorLog:(id)sender;
- (IBAction)passwordOK:(id)sender;
- (IBAction)passwordCancel:(id)sender;

- (IBAction)brightnessChanged:(id)sender;
- (void)phidgetAdded;
- (void)phidgetRemoved;
- (void)setPicture:(int)version:(CPhidget_DeviceID)devid;
@end
