/* PhidgetTextLCDController */

#import <Cocoa/Cocoa.h>
#import <Phidget21/phidget21.h>

@interface PhidgetTextLCDController : NSObject
{
	IBOutlet id mainWindow;
	
	IBOutlet NSImageView *pictureBox;
    IBOutlet NSTextField *connectedField;
    IBOutlet NSTextField *serialField;
    IBOutlet NSTextField *versionField;
	IBOutlet NSTextField *numScreensField;
	
	IBOutlet NSTextField *screenLabel;
	IBOutlet NSComboBox *screenCombo;
	
    IBOutlet NSBox *settingsBox;
	IBOutlet NSComboBox *screenSizeCombo;
    IBOutlet NSButton *backlightCheck;
    IBOutlet NSButton *cursorCheck;
    IBOutlet NSButton *cursorBlinkCheck;
    IBOutlet NSSlider *contrastSlider;
    IBOutlet NSTextField *contrastField;
    IBOutlet NSTextField *brightnessLabel;
    IBOutlet NSSlider *brightnessSlider;
    IBOutlet NSTextField *brightnessField;
	
    IBOutlet NSBox *displayBox;
	IBOutlet NSMatrix *displayStrings;
	
	IBOutlet NSPanel *errorEventLogWindow;
	IBOutlet NSTextView *errorEventLog;
	IBOutlet NSTextField *errorEventLogCounter;
	IBOutlet NSPanel *passwordPanel;
	IBOutlet NSTextField *passwordField;
	
	CPhidgetTextLCDHandle lcd;
	int numScreens, numRows, numCols;
	int baseHeight;
}
- (void)openCmdLine;

- (IBAction)clearErrorLog:(id)sender;
- (IBAction)passwordOK:(id)sender;
- (IBAction)passwordCancel:(id)sender;

- (IBAction)contrastChanged:(id)sender;
- (IBAction)brightnessChanged:(id)sender;
- (IBAction)backlightChecked:(id)sender;
- (IBAction)cursorChecked:(id)sender;
- (IBAction)cursorBlinkChecked:(id)sender;
- (IBAction)setScreen:(id)sender;
- (IBAction)setScreenSize:(id)sender;
- (IBAction)initializeScreen:(id)sender;

- (CPhidgetTextLCDHandle)getLcd;
- (void)fillForm;
- (void)setPicture:(int)version:(CPhidget_DeviceID)devid;

- (void)phidgetAdded:(id)nothing;
- (void)phidgetRemoved:(id)nothing;
@end
