//
//  AccelView.m
//
//  Created by Patrick McNeil on 10-05-20.
//  Copyright 2010 Phidgets Inc.. All rights reserved.
//

#import "VectorView.h"

static inline CGRect
convertToCGRect(NSRect rect)
{
    return CGRectMake(rect.origin.x, rect.origin.y,
					  rect.size.width, rect.size.height);
}

@implementation VectorView

- (id)initWithFrame:(NSRect)frameRect
{
    if(self = [super initWithFrame:frameRect])
	{
		circleRadius = 1.0;
		xaxis = 0;
		yaxis = 0;
		zaxis = 0;
	}
	
    return self;
}

- (void)drawRect:(NSRect)re
{
    float w, h, r;
    CGRect rect;
    CGContextRef context;
	
    rect = convertToCGRect(re);
    context = [[NSGraphicsContext currentContext] graphicsPort];
    
    /* Draw a cricle */
	w = CGRectGetWidth(rect);
	h = CGRectGetHeight(rect);
	r = (w < h) ? w/3.0 : h/3.0;
	
	CGContextBeginPath(context);
	CGContextAddArc(context, CGRectGetMidX(rect), CGRectGetMidY(rect), r, 0, 2*M_PI, false);
	CGContextSetRGBFillColor(context, 1, 1, 1, 0.5);
	CGContextFillPath(context);
	
	if(zaxis >= 0)
		CGContextSetRGBStrokeColor(context, 0, 0, 1.0, 1);
	else
		CGContextSetRGBStrokeColor(context, 1.0, 0, 0, 1);
	CGContextAddArc(context, CGRectGetMidX(rect), CGRectGetMidY(rect), zaxis*r/circleRadius, 0, 2*M_PI, false);
	CGContextStrokePath(context);
	
	CGContextSetRGBStrokeColor(context, 0, 0, 0, 1);
	CGContextMoveToPoint(context, CGRectGetMidX(rect), CGRectGetMidY(rect));
	CGContextAddLineToPoint(context, -xaxis*r/circleRadius + CGRectGetMidX(rect), yaxis*r/circleRadius + CGRectGetMidY(rect));
	CGContextStrokePath(context);
	//CGContextClosePath(context);
}

- (void)setVector:(double)x:(double)y:(double)z
{
	xaxis = x;
	yaxis = y;
	zaxis = z;
	
    [self setNeedsDisplay:YES];
}

- (void)setCircleRadius:(double)c
{
	circleRadius = c;
	
    [self setNeedsDisplay:YES];
}

@end
