/* PhidgetRFIDController */

#import <Cocoa/Cocoa.h>
#import <Phidget21/phidget21.h>

@interface PhidgetRFIDController : NSObject
{
    IBOutlet NSButton *antennaCheck;
    IBOutlet NSTextField *connectedField;
    IBOutlet NSButton *externalLEDCheck;
    IBOutlet NSButton *fiveVCheck;
    IBOutlet NSTextField *numberOfOutputsField;
    IBOutlet NSButton *onboardLEDCheck;
    IBOutlet NSTextField *serialField;
    IBOutlet NSTextField *versionField;
	IBOutlet NSTextField *tagField;
	IBOutlet id mainWindow;
	IBOutlet NSImageView *pictureBox;
    IBOutlet NSBox *settingsBox;
    IBOutlet NSBox *tagBox;
	IBOutlet NSBox *writeBox;
	IBOutlet NSPopUpButton *protocolCombo;
	IBOutlet NSTextField *writeTagString;
	IBOutlet NSButton *lockCheck;
	
	IBOutlet NSPanel *errorEventLogWindow;
	IBOutlet NSTextView *errorEventLog;
	IBOutlet NSTextField *errorEventLogCounter;
	IBOutlet NSPanel *passwordPanel;
	IBOutlet NSTextField *passwordField;
}
- (void)openCmdLine;

- (IBAction)clearErrorLog:(id)sender;
- (IBAction)passwordOK:(id)sender;
- (IBAction)passwordCancel:(id)sender;

- (IBAction)antennaChecked:(id)sender;
- (IBAction)externalLEDChecked:(id)sender;
- (IBAction)fiveVChecked:(id)sender;
- (IBAction)onboardLEDChecked:(id)sender;
- (IBAction)writeTag:(id)sender;
- (void)phidgetAdded;
- (void)phidgetRemoved;
- (void)RFIDTag:(char *)tag;
- (void)RFIDTagLost;
- (void)setPicture:(int)version:(CPhidget_DeviceID)devid;
@end
