/* PhidgetPHSensorController */

#import <Cocoa/Cocoa.h>
#import <Phidget21/phidget21.h>

@interface PhidgetPHSensorController : NSObject
{
    IBOutlet id connectedField;
    IBOutlet id mainWindow;
    IBOutlet id phField;
    IBOutlet id potentialField;
    IBOutlet id serialField;
    IBOutlet id phRangeField;
    IBOutlet id potentialRangeField;
    IBOutlet id triggerField;
    IBOutlet id temperatureField;
    IBOutlet id versionField;
	IBOutlet NSImageView *pictureBox;
    IBOutlet NSBox *sensorBox;
    IBOutlet NSBox *settingsBox;
	
	IBOutlet NSPanel *errorEventLogWindow;
	IBOutlet NSTextView *errorEventLog;
	IBOutlet NSTextField *errorEventLogCounter;
	IBOutlet NSPanel *passwordPanel;
	IBOutlet NSTextField *passwordField;
}
- (void)openCmdLine;

- (IBAction)clearErrorLog:(id)sender;
- (IBAction)passwordOK:(id)sender;
- (IBAction)passwordCancel:(id)sender;

- (IBAction)setChangeTrigger:(id)sender;
- (IBAction)setTemperature:(id)sender;
- (void)phidgetAdded;
- (void)phidgetRemoved;
- (void)gotPHChange:(double)val;
- (void)setPicture:(int)version:(CPhidget_DeviceID)devid;
@end
