//
//  TableData.m
//  CocoaRFID
//
//  Created by Allanon on 25/01/06.
//  Copyright 2006 __MyCompanyName__. All rights reserved.
//

#import "Phidget.h"

@implementation Phidget

- (id)initWithHandle:(CPhidgetHandle)phid
{
	if(self = [super init])
	{
		phidgetHandle = phid;
	}
	return self;
}

- (NSString *)phidgetName {
    const char *name;
	if(!CPhidget_getDeviceName(phidgetHandle, &name))
		return [NSString stringWithCString:name];
	else return @"";
}

- (NSString *)phidgetVersion {
    int version;
	CPhidget_getDeviceVersion(phidgetHandle, &version);
	return [NSString stringWithFormat:@"%d",version];
}

- (NSString *)phidgetSerial {
    int serial;
	CPhidget_getSerialNumber(phidgetHandle, &serial);
	return [NSString stringWithFormat:@"%d",serial];
}

- (NSString *)phidgetLabel {
    const char *label;
	if(!CPhidget_getDeviceLabel(phidgetHandle, &label))
		return [NSString stringWithCString:label encoding:NSUTF8StringEncoding];
	else return @"";
}

- (CPhidget_DeviceClass)phidgetClass
{
	CPhidget_DeviceClass class;
	CPhidget_getDeviceClass(phidgetHandle, &class);
	return class;
}

- (NSString *)phidgetType {
	const char *type;
	CPhidget_getDeviceType(phidgetHandle, &type);
	return [NSString stringWithCString:type];
}

- (CPhidgetHandle)phidgetHandle {
    return phidgetHandle;
}

- (NSString *)serverID {
	const char *serverID;
	NSString *sid;
	
	CPhidget_getServerID(phidgetHandle, &serverID);
	
	sid = [NSString stringWithCString:serverID];
	
	[sid retain];
	return sid;
}

- (BOOL)isEqual:(id)anObject{
	if (![[self phidgetName] isEqual:[anObject phidgetName]]) return false;
	if (![[self phidgetSerial] isEqual:[anObject phidgetSerial]]) return false;
	return true;
}

@end
