/* PhidgetInterfaceKitController */

#import <Cocoa/Cocoa.h>
#import <Phidget21/phidget21.h>

@interface PhidgetIRController : NSObject
{
    IBOutlet id mainWindow;
	
    IBOutlet NSTextField *connectedField;
    IBOutlet NSImageView *pictureBox;
    IBOutlet NSTextField *serialField;
    IBOutlet NSTextField *versionField;
	IBOutlet NSBox *phidgetBox;
	
	IBOutlet NSBox *codeBox;
	IBOutlet NSBox *learnBox;
	
    IBOutlet NSTextField *codeField;
    IBOutlet NSTextField *bitCountField;
    IBOutlet NSTextField *repeatCountField;
	
    IBOutlet NSTextField *learnedCodeField;
    IBOutlet NSTextField *learnedBitCountField;
    IBOutlet NSTextField *encodingField;
    IBOutlet NSTextField *gapField;
    IBOutlet NSTextField *trailField;
    IBOutlet NSTextField *zeroField;
    IBOutlet NSTextField *oneField;
    IBOutlet NSTextField *headerField;
    IBOutlet NSTextField *repeatField;
    IBOutlet NSTextField *toggleMaskField;
    IBOutlet NSTextField *lengthField;
	IBOutlet NSTextField *minRepeatField;
    IBOutlet NSButton *reTransmitButton;
	
	IBOutlet NSPanel *errorEventLogWindow;
	IBOutlet NSTextView *errorEventLog;
	IBOutlet NSTextField *errorEventLogCounter;
	IBOutlet NSPanel *passwordPanel;
	IBOutlet NSTextField *passwordField;
	
	int repeatCounter;
	CPhidgetIRHandle ir;
}
- (void)openCmdLine;

- (IBAction)clearErrorLog:(id)sender;
- (IBAction)passwordOK:(id)sender;
- (IBAction)passwordCancel:(id)sender;

- (IBAction)reTransmit:(id)sender;
- (void)phidgetAdded:(id)nothing;
- (void)phidgetRemoved:(id)nothing;

@end
