/* PhidgetInterfaceKitController */

#import <Cocoa/Cocoa.h>
#import <Phidget21/phidget21.h>

@interface PhidgetInterfaceKitController : NSObject
{
    IBOutlet NSTextField *connectedField;
    IBOutlet NSMatrix *inputLabels;
    IBOutlet NSMatrix *inputs;
    IBOutlet NSBox *inputsBox;
    IBOutlet NSWindow *mainWindow;
    IBOutlet NSTextField *numInputsField;
    IBOutlet NSTextField *numOutputsField;
    IBOutlet NSTextField *numSensorsField;
    IBOutlet NSMatrix *outputLabels;
    IBOutlet NSMatrix *outputs;
    IBOutlet NSBox *outputsBox;
    IBOutlet NSImageView *pictureBox;
    IBOutlet NSButton *ratiometric;
    IBOutlet NSTextField *sensitivityField;
    IBOutlet NSSlider *sensitivitySlider;
    IBOutlet NSBox *sensorsBox;
    IBOutlet NSMatrix *sensorFields;
    IBOutlet NSMatrix *sensorLabels;
    IBOutlet NSMatrix *sensorSliders;
    IBOutlet NSTextField *serialField;
    IBOutlet NSTextField *versionField;
	IBOutlet NSBox *phidgetBox;
	
	IBOutlet NSPanel *errorEventLogWindow;
	IBOutlet NSTextView *errorEventLog;
	IBOutlet NSTextField *errorEventLogCounter;
	IBOutlet NSPanel *passwordPanel;
	IBOutlet NSTextField *passwordField;
	
	CPhidgetInterfaceKitHandle ifkit;
	int numOutputs, numInputs, numSensors;
}
- (void)openCmdLine;

- (IBAction)clearErrorLog:(id)sender;
- (IBAction)passwordOK:(id)sender;
- (IBAction)passwordCancel:(id)sender;

- (IBAction)output:(id)sender;
- (IBAction)ratiometric:(id)sender;
- (IBAction)sensitivity:(id)sender;

- (void)OutputChange:(NSArray *)outputChangeData;
- (void)InputChange:(NSArray *)inputChangeData;
- (void)SensorChange:(NSArray *)sensorChangeData;

- (void)phidgetAdded:(id)nothing;
- (void)phidgetRemoved:(id)nothing;

@end
