/* PhidgetGPSController */

#import <Cocoa/Cocoa.h>
#import <Phidget21/phidget21.h>

@interface PhidgetGPSController : NSObject
{
    IBOutlet id altitudeField;
    IBOutlet id connectedField;
    IBOutlet id headingField;
    IBOutlet id latitudeField;
    IBOutlet id longitudeField;
    IBOutlet id mainWindow;
    IBOutlet id serialField;
    IBOutlet id speedField;
    IBOutlet NSButton *fixStatus;
    IBOutlet id timeField;
    IBOutlet id versionField;
	IBOutlet NSBox *phidgetBox;
	IBOutlet NSBox *gpsBox;
    IBOutlet NSImageView *pictureBox;
	
	IBOutlet NSPanel *errorEventLogWindow;
	IBOutlet NSTextView *errorEventLog;
	IBOutlet NSTextField *errorEventLogCounter;
	IBOutlet NSPanel *passwordPanel;
	IBOutlet NSTextField *passwordField;
	
	CPhidgetGPSHandle gps;
}
- (void)openCmdLine;

- (IBAction)clearErrorLog:(id)sender;
- (IBAction)passwordOK:(id)sender;
- (IBAction)passwordCancel:(id)sender;

- (void)setPicture:(int)version:(CPhidget_DeviceID)devid;

- (void)PositionChange:(NSArray *)positionChangeData;
- (void)PositionFixStatusChange:(NSNumber *)positionFixStatus;

- (void)phidgetAdded:(id)nothing;
- (void)phidgetRemoved:(id)nothing;
@end
