/* PhidggetTemperatureSensorController */

#import <Cocoa/Cocoa.h>
#import <Phidget21/phidget21.h>

@interface PhidgetBridgeController : NSObject
{
	IBOutlet id mainWindow;
	
	IBOutlet NSImageView *pictureBox;
    IBOutlet NSTextField *connectedField;
    IBOutlet NSTextField *serialField;
    IBOutlet NSTextField *versionField;
    IBOutlet NSTextField *numInputsField;
	
    IBOutlet NSTextField *dataRateField;
	IBOutlet NSSlider *dataRateSlider;
	
	IBOutlet NSMatrix *enabledChecks;
	IBOutlet NSMatrix *gainComboBoxes;
	IBOutlet NSMatrix *valueSliders;
	IBOutlet NSMatrix *valueFields;
	IBOutlet NSMatrix *rangeFields;
	
    IBOutlet NSBox *inputsBox;
	
	IBOutlet NSPanel *errorEventLogWindow;
	IBOutlet NSTextView *errorEventLog;
	IBOutlet NSTextField *errorEventLogCounter;
	IBOutlet NSPanel *passwordPanel;
	IBOutlet NSTextField *passwordField;
	
	CPhidgetBridgeHandle bridge;
	int numInputs;
}
- (void)openCmdLine;

- (IBAction)clearErrorLog:(id)sender;
- (IBAction)passwordOK:(id)sender;
- (IBAction)passwordCancel:(id)sender;

- (IBAction)setInputEnabled:(id)sender;
- (IBAction)setGain:(id)sender;
- (IBAction)setDataRate:(id)sender;

- (void)setRange:(int)index;
- (void)setPicture:(int)version:(CPhidget_DeviceID)devid;

- (void)phidgetAdded:(id)nothing;
- (void)phidgetRemoved:(id)nothing;
- (void)BridgeData:(NSArray *)bridgeData;
@end
