/* PhidggetTemperatureSensorController */

#import <Cocoa/Cocoa.h>
#import <Phidget21/phidget21.h>

@interface PhidgetAnalogController : NSObject
{
	IBOutlet id mainWindow;
	
	IBOutlet NSImageView *pictureBox;
    IBOutlet NSTextField *connectedField;
    IBOutlet NSTextField *serialField;
    IBOutlet NSTextField *versionField;
    IBOutlet NSTextField *numOutputsField;
    IBOutlet NSTextField *outputRangeField;
	
    IBOutlet NSMatrix *outputLabels;
    IBOutlet NSMatrix *outputsEnabled;
    IBOutlet NSMatrix *outputSliders;
    IBOutlet NSMatrix *outputValues;
	
    IBOutlet NSBox *outputsBox;
	
	IBOutlet NSPanel *errorEventLogWindow;
	IBOutlet NSTextView *errorEventLog;
	IBOutlet NSTextField *errorEventLogCounter;
	IBOutlet NSPanel *passwordPanel;
	IBOutlet NSTextField *passwordField;
	
	CPhidgetAnalogHandle analog;
	int numOutputs;
}
- (void)openCmdLine;

- (IBAction)clearErrorLog:(id)sender;
- (IBAction)passwordOK:(id)sender;
- (IBAction)passwordCancel:(id)sender;

- (IBAction)setOutputEnabled:(id)sender;
- (IBAction)setVoltage:(id)sender;

- (void)setPicture:(int)version:(CPhidget_DeviceID)devid;

- (void)phidgetAdded:(id)nothing;
- (void)phidgetRemoved:(id)nothing;
@end
