/* PhidgetAccelerometerController */

#import <Cocoa/Cocoa.h>
#import "AccelView.h"
#import <Phidget21/phidget21.h>

@interface PhidgetAccelerometerController : NSObject
{
    IBOutlet NSTextField *connectedField;
    IBOutlet AccelView *customView;
    IBOutlet NSBox *sensorBox;
    IBOutlet NSTextField *numberOfAxesField;
	IBOutlet NSTextField *rangeField;
    IBOutlet NSTextField *serialNumberField;
    IBOutlet NSTextField *versionField;
	IBOutlet NSImageView *pictureBox;
	IBOutlet id mainWindow;
	IBOutlet NSTextField *xField;
	IBOutlet NSTextField *yField;
	IBOutlet NSTextField *zField;
	IBOutlet NSTextField *zLabel;
	
	IBOutlet NSPanel *errorEventLogWindow;
	IBOutlet NSTextView *errorEventLog;
	IBOutlet NSTextField *errorEventLogCounter;
	IBOutlet NSPanel *passwordPanel;
	IBOutlet NSTextField *passwordField;
	
	double xaxis[7], yaxis[7], zaxis[7];
}
- (void)openCmdLine;

- (IBAction)clearErrorLog:(id)sender;
- (IBAction)passwordOK:(id)sender;
- (IBAction)passwordCancel:(id)sender;

- (void)phidgetRemoved;
- (void)phidgetAdded;
- (void)gotAccelChange:(int)index:(double)value;
- (void)setPicture:(int)version:(CPhidget_DeviceID)devid;
@end
