// stdafx.h : include file for standard system include files,
// or project specific include files that are used frequently, but
// are changed infrequently
//

#ifndef __STDAFX
#define __STDAFX

#include <stdio.h>

#ifdef _DEBUG /*defined in the command line*/
#ifndef _MSC_EXTENSIONS
#define DPRINT(...) ( printf("%s(%d): ", __func__, __LINE__), \
    printf(__VA_ARGS__), printf("\n"), fflush(stdout), (void)0 )
#else
#define DPRINT(...) ( printf("%s+%d: ", __FILE__, __LINE__), \
    printf(__VA_ARGS__), printf("\n"), fflush(stdout), (void)0 )
#endif
#else
#define DPRINT(...) ((void)0)
#endif

#define WARN(...) (fprintf(stderr, "PHIDGET21: " __VA_ARGS__), fprintf(stderr, \
    "\n"), fflush(stderr), (void)0)

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#ifdef _WINDOWS
// Defines & Include for Windows only

	// Modify the following defines if you have to target a platform prior to the ones specified below.
	// Refer to MSDN for the latest info on corresponding values for different platforms.
	#ifndef WINVER				// Allow use of features specific to Windows XP or later.
	#define WINVER 0x0501		// Change this to the appropriate value to target other versions of Windows.
	#endif

	#ifndef _WIN32_WINNT		// Allow use of features specific to Windows XP or later.                   
	#define _WIN32_WINNT 0x0501	// Change this to the appropriate value to target other versions of Windows.
	#endif						

	#ifndef _WIN32_WINDOWS		// Allow use of features specific to Windows 98 or later.
	#define _WIN32_WINDOWS 0x0410 // Change this to the appropriate value to target Windows Me or later.
	#endif

	#ifndef _WIN32_IE			// Allow use of features specific to IE 6.0 or later.
	#define _WIN32_IE 0x0600	// Change this to the appropriate value to target other versions of IE.
	#endif

	#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
	// Windows Header Files:
	#include <winsock2.h>
	#include <ws2tcpip.h>
	#include <windows.h>
	#include <winbase.h>
	#include <stdio.h>
	#include <stdlib.h>
	#include <time.h>
	#include <assert.h>

	//#define CCONV __cdecl
	#define CCONV __stdcall
	#define SLEEP(dlay) Sleep(dlay);
	#define ZEROMEM(var,size) ZeroMemory(var, size);

	#ifdef PHIDGET21_EXPORTS
	#ifndef PHIDGET21_API
	#define PHIDGET21_API 
	#endif
	#else
	#ifndef PHIDGET21_API
	#define PHIDGET21_API __declspec(dllimport)
	#endif
	#endif
	
	typedef SYSTEMTIME TIME;
	
#else
// Defines & Include for both Mac and Linux
	#include <semaphore.h>
	#include <time.h>
	#include <stdio.h>
	#include <stdlib.h>
	#include <string.h>
	#include <pthread.h>
	#include <errno.h>
	#include <sys/types.h>
	#include <sys/socket.h>
	#include <netinet/in.h>
	#include <arpa/inet.h>
	#include <netdb.h>
	#include <unistd.h>
	#include <sys/time.h>

	#define CCONV
	#define SLEEP(dlay) usleep(dlay*1000);
	#define ZEROMEM(var,size) memset(var, 0, size);
	#ifndef PHIDGET21_API
	#define PHIDGET21_API
	//typedef sem_t CRITICAL_SECTION;
	typedef void *HANDLE;
	#define INFINITE 0xFFFFFFFF
	typedef long *LPDWORD;
	#define STILL_ACTIVE 0x00000103L
	#define WAIT_TIMEOUT 258L
	#define WAIT_OBJECT_0 0x00000000L
	
	typedef struct timeval TIME;
	
#endif

#ifdef _MACOSX
// Defines & Include for Mac only
#include <CoreFoundation/CoreFoundation.h>
#include <mach/mach.h>

#elif _LINUX
// Defines & Include for Linux Only

#endif
#endif

#endif


