/* PhidggetTemperatureSensorController */

#import <Cocoa/Cocoa.h>
#include <Phidget21/phidget21.h>

@interface PhidggetTemperatureSensorController : NSObject
{
	IBOutlet id mainWindow;
	
	IBOutlet NSImageView *pictureBox;
    IBOutlet NSTextField *connectedField;
    IBOutlet NSTextField *numInputsField;
    IBOutlet NSTextField *serialField;
    IBOutlet NSTextField *versionField;
    IBOutlet NSTextField *temperatureRangeField;
    IBOutlet NSTextField *potentialRangeField;
	
    IBOutlet NSBox *sensorBox;
    IBOutlet NSBox *settingsBox;
	
	IBOutlet NSMatrix *thermocoupleSelects;
	IBOutlet NSMatrix *temperatures;
	IBOutlet NSMatrix *temperatureLabels;
	IBOutlet NSMatrix *potentials;
    IBOutlet NSTextField *ambientTempField;
    IBOutlet NSTextField *triggerField;
	
	CPhidgetTemperatureSensorHandle temp;
	int numInputs;
}
- (IBAction)setChangeTrigger:(id)sender;
- (IBAction)choseThermocoupleType:(id)sender;
- (void)setPicture:(int)version:(CPhidget_DeviceID)devid;

- (void)TemperatureChange:(NSArray *)temperatureChangeData;

- (void)phidgetAdded:(id)nothing;
- (void)phidgetRemoved:(id)nothing;
@end
