//
//  CompassView.m
//
//  Created by Patrick McNeil on 10-05-21.
//  Copyright 2010 Phidgets Inc.. All rights reserved.
//

#import "CompassView.h"

static inline CGRect
convertToCGRect(NSRect rect)
{
    return CGRectMake(rect.origin.x, rect.origin.y,
					  rect.size.width, rect.size.height);
}

@implementation CompassView

- (id)initWithFrame:(NSRect)frameRect
{
    if(self = [super initWithFrame:frameRect])
	{
		bearing = 0;
		img = [NSImage imageNamed:@"1056_0_Top"];
	}
	
    return self;
}

- (void)setBearing:(double)b
{
	bearing = b;
	
    [self setNeedsDisplay:YES];
}

- (NSImage*)rotateImage:(NSImage*)orig byDegrees:(float)deg{
	NSImage *rotated = [[NSImage alloc] initWithSize:[orig size]];
	[rotated lockFocus];
	
	//Need to translate the image so it's centered at the origin before rotating
	NSAffineTransform *transform = [NSAffineTransform transform];
	[transform translateXBy:[orig size].width/2.0 yBy:[orig size].height/2.0];
	[transform rotateByRadians:deg];
	[transform translateXBy:-[orig size].width/2.0 yBy:-[orig size].height/2.0];
	[transform concat];
	
	[orig drawAtPoint:NSZeroPoint fromRect:NSZeroRect operation:NSCompositeCopy fraction:1.0];
	[rotated unlockFocus];
	[orig autorelease];
	return [rotated autorelease];
}

- (void)drawRect:(NSRect)re
{
	int i;
    float w, h, r;
    CGRect rect;
    CGContextRef context;
	
    rect = convertToCGRect(re);
    context = [[NSGraphicsContext currentContext] graphicsPort];
    
	w = CGRectGetWidth(rect);
	h = CGRectGetHeight(rect);
	r = (w < h) ? w/3.2 : h/3.2;
	
	//Draw the image
	[[NSGraphicsContext currentContext]
     setImageInterpolation: NSImageInterpolationHigh];
	
	NSSize viewSize  = [self bounds].size;
	double newWidth = (int)([img size].width * (h / [img size].height) * 0.55);
	double newHeight = (int)(h * 0.55);
	NSSize imageSize = { newWidth, newHeight };
	
	NSPoint viewCenter;
	viewCenter.x = viewSize.width  * 0.50;
	viewCenter.y = viewSize.height * 0.50;
	
	NSPoint imageOrigin = viewCenter;
	imageOrigin.x -= imageSize.width  * 0.50;
	imageOrigin.y -= imageSize.height * 0.50;
	
	NSRect destRect;
	destRect.origin = imageOrigin;
	destRect.size = imageSize;
	
	NSImage *rotatedImage = [self rotateImage:[img copy] byDegrees:-bearing];
	[rotatedImage drawInRect:destRect fromRect:NSZeroRect
		  operation: NSCompositeSourceOver
					fraction: 1.0];
	
    /* Draw a cricle */
	CGContextBeginPath(context);
	CGContextAddArc(context, CGRectGetMidX(rect), CGRectGetMidY(rect), r, 0, 2*M_PI, false);
	CGContextSetRGBStrokeColor(context, 0,0,0, 1);
	CGContextStrokePath(context);
	
	//Ticks around the compass circle
	CGContextSetRGBStrokeColor(context, 0, 0, 0, 1);
	for (i = 0; i < 360; i+=10)
	{
		int tickSize = 4;
		CGContextSetLineWidth(context, 1);
		if (i == 0 || i == 90 || i == 180 || i == 270)
		{
			CGContextSetLineWidth(context, 2);
			tickSize = 6;
		}
		
		CGContextMoveToPoint(context, (r + tickSize) * cos(i * (M_PI / 180.0)) + CGRectGetMidX(rect), 
							 -(r + tickSize) * sin(i * (M_PI / 180.0)) + CGRectGetMidY(rect));
		CGContextAddLineToPoint(context, (r - tickSize) * cos(i * (M_PI / 180.0)) + CGRectGetMidX(rect), 
								-(r - tickSize) * sin(i * (M_PI / 180.0)) + CGRectGetMidY(rect));
		CGContextStrokePath(context);
	}
	
	//Draw nesw
	CGContextSelectFont (context,"Helvetica-Bold",h/15,kCGEncodingMacRoman);
	CGContextShowTextAtPoint(context, CGRectGetMidX(rect)-7, CGRectGetMidY(rect)+r+10, "N", 1);
	CGContextShowTextAtPoint(context, CGRectGetMidX(rect)-7, CGRectGetMidY(rect)-r-22, "S", 1);
	CGContextShowTextAtPoint(context, CGRectGetMidY(rect)+r+10, CGRectGetMidX(rect)-7, "E", 1);
	CGContextShowTextAtPoint(context, CGRectGetMidY(rect)-r-22, CGRectGetMidX(rect)-7, "W", 1);
	
    /* Draw the small circle */
	CGContextBeginPath(context);
	CGContextAddArc(context, CGRectGetMidX(rect) + (r * cos(-bearing+1.57)), 
					CGRectGetMidY(rect) + (r * sin(-bearing+1.57)), 
					4, 0, 2*M_PI, false);
	CGContextSetRGBFillColor(context, 0,0,0,1);
	CGContextFillPath(context);
	
}

@end
