//
//  CompassBearing.h
//  CocoaSpatial
//
//  Created by Patrick McNeil on 10-05-21.
//  Copyright 2010 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface CompassBearing : NSObject {
	double ax,ay,az,cx,cy,cz;
	double declination;
	double bearing, bearingDegrees;
	double filterConstant;
	Boolean useDeclination;
}
- (void)setAccelerationVector:(double)x:(double)y:(double)z;
- (void)setMagneticFieldVector:(double)x:(double)y:(double)z;
- (void)setDeclination:(double)d;
- (void)updateBearing;
- (void)setUseDeclination:(Boolean)state;
- (void)setSampleRate:(double)rate cutoffFrequency:(double)freq;

@property(nonatomic, readonly) double bearing;
@property(nonatomic, readonly) double bearingDegrees;

@end
