//
//  PhidgetSpatialController.h
//  CocoaSpatial
//
//  Created by Patrick McNeil on 10-05-20.
//  Copyright 2010 Phidgets Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <Phidget21/phidget21.h>
#import <CoreLocation/CoreLocation.h>
#import "PhidgetSpatialEventData.h"
#import "VectorView.h"
#import "GyroView.h"
#import "CompassView.h"
#import "SpatialDataFilter.h"
#import "CompassBearing.h"
 
@interface PhidgetSpatialController : NSWindowController <NSWindowDelegate, CLLocationManagerDelegate> {
	
    IBOutlet NSTextField *connectedField;
    IBOutlet NSWindow *mainWindow;
    IBOutlet NSImageView *pictureBox;
    IBOutlet NSTextField *serialField;
    IBOutlet NSTextField *versionField;
	IBOutlet NSBox *phidgetBox;
	
    IBOutlet NSTextField *numAccelAxesField;
    IBOutlet NSTextField *numGyroAxesField;
    IBOutlet NSTextField *numCompassAxesField;
	
	IBOutlet NSBox *accelBox;
	IBOutlet VectorView *accelView;
	IBOutlet NSButton *accelFilterEnabled;
	
	IBOutlet NSBox *gyroBox;
	IBOutlet GyroView *gyroView;
	
	IBOutlet NSBox *magFieldBox;
	IBOutlet VectorView *magFieldView;
	IBOutlet NSButton *magFieldFilterEnabled;
	
	IBOutlet NSBox *compassBox;
	IBOutlet CompassView *compassView;
	IBOutlet NSMatrix *northTypeButtons;
	IBOutlet NSTextField *bearingField;
	
	CLLocationManager *locationManager;
	CLLocation *location;
	double magFieldStrength, magDeclination;
	
	SpatialDataFilter *accelFilter;
	SpatialDataFilter *magFieldFilter;
	CompassBearing *compassBearing;
	
	double lastMsCount[3];
	double gyroHeading[3];
	Boolean lastMsCountGood[3];
	
	CPhidgetSpatialHandle spatial;
	int numAccelAxes, numGyroAxes, numCompassAxes;
}

- (void)phidgetAdded:(id)nothing;
- (void)phidgetRemoved:(id)nothing;

- (void)SpatialData:(PhidgetSpatialEventData *)spatialData;

- (void)locationManager:(CLLocationManager *)manager
    didUpdateToLocation:(CLLocation *)newLocation
           fromLocation:(CLLocation *)oldLocation;

- (void)locationManager:(CLLocationManager *)manager
       didFailWithError:(NSError *)error;

- (IBAction)changeNorthType:(id)sender;
- (IBAction)zeroGyro:(id)sender;

- (void)calculateGyroHeadings:(PhidgetSpatialEventData *)data;

@end
