/* PhidgetRFIDController */

#import <Cocoa/Cocoa.h>
#include <Phidget21/phidget21.h>

@interface PhidgetRFIDController : NSObject
{
    IBOutlet NSButton *antennaCheck;
    IBOutlet NSTextField *connectedField;
    IBOutlet NSButton *externalLEDCheck;
    IBOutlet NSButton *fiveVCheck;
    IBOutlet NSTextField *numberOfOutputsField;
    IBOutlet NSButton *onboardLEDCheck;
    IBOutlet NSTextField *serialField;
    IBOutlet NSTextField *versionField;
	IBOutlet NSTextField *tagField;
	IBOutlet id mainWindow;
	IBOutlet NSImageView *pictureBox;
    IBOutlet NSBox *settingsBox;
    IBOutlet NSBox *tagBox;
}
- (IBAction)antennaChecked:(id)sender;
- (IBAction)externalLEDChecked:(id)sender;
- (IBAction)fiveVChecked:(id)sender;
- (IBAction)onboardLEDChecked:(id)sender;
- (void)phidgetAdded;
- (void)phidgetRemoved;
- (void)RFIDTag:(unsigned char *)tag;
- (void)RFIDTagLost;
- (void)setPicture:(int)version:(CPhidget_DeviceID)devid;
@end
