/* PhidgetPHSensorController */

#import <Cocoa/Cocoa.h>
#include <Phidget21/phidget21.h>

@interface PhidgetPHSensorController : NSObject
{
    IBOutlet id connectedField;
    IBOutlet id mainWindow;
    IBOutlet id phField;
    IBOutlet id potentialField;
    IBOutlet id serialField;
    IBOutlet id phRangeField;
    IBOutlet id potentialRangeField;
    IBOutlet id triggerField;
    IBOutlet id temperatureField;
    IBOutlet id versionField;
	IBOutlet NSImageView *pictureBox;
    IBOutlet NSBox *sensorBox;
    IBOutlet NSBox *settingsBox;
}
- (IBAction)setChangeTrigger:(id)sender;
- (IBAction)setTemperature:(id)sender;
- (void)phidgetAdded;
- (void)phidgetRemoved;
- (void)gotPHChange:(double)val;
- (void)setPicture:(int)version:(CPhidget_DeviceID)devid;
@end
