/* PhidgetMotorController */

#import <Cocoa/Cocoa.h>
#include <Phidget21/phidget21.h>

@interface PhidgetMotorController : NSObject
{
	IBOutlet id mainWindow;
	
	IBOutlet NSImageView *pictureBox;
    IBOutlet NSTextField *connectedField;
    IBOutlet NSTextField *serialField;
    IBOutlet NSTextField *versionField;
    IBOutlet NSTextField *numInputsField;
    IBOutlet NSTextField *numMotorsField;
    IBOutlet NSTextField *numEncodersField;
    IBOutlet NSTextField *numSensorsField;
	
	/* Motor Control box */
	IBOutlet NSTextField *targetVelocityLabel;
	IBOutlet NSTextField *accelerationLabel;
	IBOutlet NSTextField *brakingLabel;
	IBOutlet NSTextField *backEMFStateLabel;
	IBOutlet NSMatrix *motorControlLabels;
	IBOutlet NSMatrix *targetVelocitySliders;
	IBOutlet NSMatrix *targetVelocityFields;
	IBOutlet NSMatrix *accelerationSliders;
	IBOutlet NSMatrix *accelerationFields;
	IBOutlet NSMatrix *brakingSliders;
	IBOutlet NSMatrix *brakingFields;
	IBOutlet NSMatrix *backEMFStateChecks;
	
	/* Motor State box */
	IBOutlet NSTextField *velocityLabel;
	IBOutlet NSTextField *currentLabel;
	IBOutlet NSTextField *backEMFLabel;
	IBOutlet NSMatrix *motorStateLabels;
	IBOutlet NSMatrix *velocitySliders;
	IBOutlet NSMatrix *velocityFields;
	IBOutlet NSMatrix *currentSliders;
	IBOutlet NSMatrix *currentFields;
	IBOutlet NSMatrix *backEMFSliders;
	IBOutlet NSMatrix *backEMFFields;
	IBOutlet NSTextField *supplyVoltageLabel;
	IBOutlet NSTextField *supplyVoltageField;
	
	/* Digital Inputs box */
    IBOutlet NSMatrix *inputs;
	
	/* Encoders box */
	IBOutlet NSSlider *encoderPositionSlider;
	IBOutlet NSTextField *encoderPosition;
	
	/* Sensors box */
	IBOutlet NSMatrix *sensorSliders;
	IBOutlet NSMatrix *sensorFields;
	IBOutlet NSButton *ratiometricCheck;
	
    IBOutlet NSBox *motorsetBox;
    IBOutlet NSBox *motorstateBox;
    IBOutlet NSBox *inputBox;
    IBOutlet NSBox *encoderBox;
    IBOutlet NSBox *sensorBox;
	
	NSTimer *supplyVoltageTimer;
	
	CPhidgetMotorControlHandle motor;
	int numMotors, numInputs, numEncoders, numSensors;
}
- (IBAction)setAccel:(id)sender;
- (IBAction)setVelocity:(id)sender;
- (IBAction)setBackEMFState:(id)sender;
- (IBAction)setBraking:(id)sender;
- (IBAction)resetEncoderPosition:(id)sender;
- (IBAction)setRatiometric:(id)sender;

- (void)setPicture:(int)version:(CPhidget_DeviceID)devid;
- (void)resizeMatrix:(NSMatrix *)matrix:(int)size;

- (void)phidgetAdded:(id)nothing;
- (void)phidgetRemoved:(id)nothing;

- (void)BackEMFUpdate:(NSArray *)backEMFData;
- (void)VelocityChange:(NSArray *)velocityData;
- (void)CurrentChange:(NSArray *)currentData;
- (void)InputChange:(NSArray *)inputData;
- (void)SensorUpdate:(NSArray *)sensorData;
- (void)EncoderPositionChange:(NSArray *)encoderData;
@end
