/* PhidgetInterfaceKitController */

#import <Cocoa/Cocoa.h>
#include <Phidget21/phidget21.h>

@interface PhidgetIRController : NSObject
{
    IBOutlet NSTextField *connectedField;
    IBOutlet NSWindow *mainWindow;
    IBOutlet NSImageView *pictureBox;
    IBOutlet NSTextField *serialField;
    IBOutlet NSTextField *versionField;
	IBOutlet NSBox *phidgetBox;
	
	IBOutlet NSBox *codeBox;
	IBOutlet NSBox *learnBox;
	
    IBOutlet NSTextField *codeField;
    IBOutlet NSTextField *bitCountField;
    IBOutlet NSTextField *repeatCountField;
	
    IBOutlet NSTextField *learnedCodeField;
    IBOutlet NSTextField *learnedBitCountField;
    IBOutlet NSTextField *encodingField;
    IBOutlet NSTextField *gapField;
    IBOutlet NSTextField *trailField;
    IBOutlet NSTextField *zeroField;
    IBOutlet NSTextField *oneField;
    IBOutlet NSTextField *headerField;
    IBOutlet NSTextField *repeatField;
    IBOutlet NSTextField *toggleMaskField;
    IBOutlet NSTextField *lengthField;
	IBOutlet NSTextField *minRepeatField;
    IBOutlet NSButton *reTransmitButton;
	
	int repeatCounter;
	CPhidgetIRHandle ir;
}

- (IBAction)reTransmit:(id)sender;
- (void)phidgetAdded:(id)nothing;
- (void)phidgetRemoved:(id)nothing;

@end
