/* PhidggetTemperatureSensorController */

#import <Cocoa/Cocoa.h>
#include <Phidget21/phidget21.h>

@interface PhidgetFrequencyCounterController : NSObject
{
	IBOutlet id mainWindow;
	
	IBOutlet NSImageView *pictureBox;
    IBOutlet NSTextField *connectedField;
    IBOutlet NSTextField *serialField;
    IBOutlet NSTextField *versionField;
    IBOutlet NSTextField *numInputsField;
	
	IBOutlet NSMatrix *enabledChecks;
	IBOutlet NSMatrix *filterComboBoxes;
	IBOutlet NSMatrix *freqFields;
	IBOutlet NSMatrix *timeoutSliders;
	IBOutlet NSMatrix *timeoutFields;
	
    IBOutlet NSBox *inputsBox;
	
	CPhidgetFrequencyCounterHandle freq;
	int numInputs;
}
- (IBAction)setInputEnabled:(id)sender;
- (IBAction)setFilter:(id)sender;
- (IBAction)setTimeout:(id)sender;

- (void)setPicture:(int)version:(CPhidget_DeviceID)devid;

- (void)phidgetAdded:(id)nothing;
- (void)phidgetRemoved:(id)nothing;
- (void)Count:(NSArray *)countData;
@end
