/* PhidgetEncoderController */

#import <Cocoa/Cocoa.h>
#include <Phidget21/phidget21.h>

@interface PhidgetEncoderController : NSObject
{
	IBOutlet id mainWindow;
	
	IBOutlet NSImageView *pictureBox;
    IBOutlet NSTextField *connectedField;
    IBOutlet NSTextField *numEncodersField;
    IBOutlet NSTextField *numInputsField;
    IBOutlet NSTextField *serialField;
    IBOutlet NSTextField *versionField;
	
    IBOutlet NSMatrix *inputLabels;
    IBOutlet NSMatrix *inputs;
    IBOutlet NSBox *inputsBox;
	
    IBOutlet NSBox *encoderBox;
    IBOutlet NSMatrix *encoderLabels;
    IBOutlet NSMatrix *positions;
    IBOutlet NSMatrix *indexes;
	IBOutlet NSTextField *indexLabel;
    IBOutlet NSMatrix *positionSliders;
    IBOutlet NSMatrix *msTimes;
    IBOutlet NSMatrix *enabledCheckboxes;
	IBOutlet NSTextField *timeLabel;
	
	CPhidgetEncoderHandle encoder;
	int numInputs, numEncoders;
}
- (IBAction)enable:(id)sender;

- (void)setPicture:(int)version:(CPhidget_DeviceID)devid;

- (void)InputChange:(NSArray *)inputChangeData;
- (void)PositionChange:(NSArray *)positionChangeData;

- (void)phidgetAdded:(id)nothing;
- (void)phidgetRemoved:(id)nothing;
@end
