/* PhidggetTemperatureSensorController */

#import <Cocoa/Cocoa.h>
#include <Phidget21/phidget21.h>

@interface PhidgetAnalogController : NSObject
{
	IBOutlet id mainWindow;
	
	IBOutlet NSImageView *pictureBox;
    IBOutlet NSTextField *connectedField;
    IBOutlet NSTextField *serialField;
    IBOutlet NSTextField *versionField;
    IBOutlet NSTextField *numOutputsField;
    IBOutlet NSTextField *outputRangeField;
	
    IBOutlet NSMatrix *outputLabels;
    IBOutlet NSMatrix *outputsEnabled;
    IBOutlet NSMatrix *outputSliders;
    IBOutlet NSMatrix *outputValues;
	
    IBOutlet NSBox *outputsBox;
	
	CPhidgetAnalogHandle analog;
	int numOutputs;
}
- (IBAction)setOutputEnabled:(id)sender;
- (IBAction)setVoltage:(id)sender;

- (void)setPicture:(int)version:(CPhidget_DeviceID)devid;

- (void)phidgetAdded:(id)nothing;
- (void)phidgetRemoved:(id)nothing;
@end
