/* PhidgetServoController */

#import <Cocoa/Cocoa.h>
#include <Phidget21/phidget21.h>

@interface PhidgetServoController : NSObject
{
    IBOutlet NSTextField *connectedField;
    IBOutlet NSTextField *numberOfServosField;
    IBOutlet id scroll1;
    IBOutlet id scroll2;
    IBOutlet id scroll3;
    IBOutlet id scroll4;
    IBOutlet id scroll5;
    IBOutlet id scroll6;
    IBOutlet id scroll7;
    IBOutlet id scroll8;
    IBOutlet id scrollAll;
    IBOutlet id currentPositionSliders;
    IBOutlet id currentCurrents;
    IBOutlet id currentCurrentSliders;
    IBOutlet id currentPositions;
    IBOutlet id currentVelocities;
    IBOutlet id setAccelerations;
    IBOutlet id setPositions;
    IBOutlet id setVelocities;
	IBOutlet id speedRampingButtons;
	IBOutlet id stopButtons;
    IBOutlet NSTextField *serialField;
	IBOutlet NSTextField *versionField;
	IBOutlet id stoppedCheckBoxes;
	IBOutlet id mainWindow;
	IBOutlet NSImageView *pictureBox;
    IBOutlet NSBox *inputBox;
    IBOutlet NSBox *outputBox;
}
- (IBAction)moveServo:(id)sender;
- (IBAction)accelServo:(id)sender;
- (IBAction)velocityServo:(id)sender;
- (IBAction)stopServo:(id)sender;
- (IBAction)setSpeedRamping:(id)sender;
- (IBAction)setMaxAngle:(id)sender;
- (IBAction)setMinAngle:(id)sender;
- (void)phidgetAdded;
- (void)phidgetRemoved;
- (void)positionChange:(int)Index:(double)Value;
- (void)velocityChange:(int)Index:(double)Value;
- (void)currentChange:(int)Index:(double)Value;
- (void)setPicture:(int)version:(CPhidget_DeviceID)devid;
@end
