/* PhidgetAccelerometerController */

#import <Cocoa/Cocoa.h>
#import "AccelView.h"
#include <Phidget21/phidget21.h>

@interface PhidgetAccelerometerController : NSObject
{
    IBOutlet NSTextField *connectedField;
    IBOutlet AccelView *customView;
    IBOutlet NSBox *sensorBox;
    IBOutlet NSTextField *numberOfAxesField;
	IBOutlet NSTextField *rangeField;
    IBOutlet NSTextField *serialNumberField;
    IBOutlet NSTextField *versionField;
	IBOutlet NSImageView *pictureBox;
	IBOutlet id mainWindow;
	IBOutlet NSTextField *xField;
	IBOutlet NSTextField *yField;
	IBOutlet NSTextField *zField;
	IBOutlet NSTextField *zLabel;
	
	double xaxis[7], yaxis[7], zaxis[7];
}
- (void)phidgetRemoved;
- (void)phidgetAdded;
- (void)gotAccelChange:(int)index:(double)value;
- (void)setPicture:(int)version:(CPhidget_DeviceID)devid;
@end
