/* PhidgetTextLCDController */

#import <Cocoa/Cocoa.h>
#include <Phidget21/phidget21.h>

@interface PhidgetTextLCDController : NSObject
{
    IBOutlet NSTextField *connectedField;
    IBOutlet NSSlider *contrastSlider;
    IBOutlet NSTextField *contrastField;
    IBOutlet NSTextField *row1Box;
    IBOutlet NSTextField *row2Box;
    IBOutlet NSTextField *serialField;
    IBOutlet NSTextField *versionField;
    IBOutlet NSTextField *numRowsField;
    IBOutlet NSTextField *numColsField;
	IBOutlet id mainWindow;
	IBOutlet NSImageView *pictureBox;
    IBOutlet NSBox *settingsBox;
    IBOutlet NSBox *displayBox;
    IBOutlet NSButton *backlightCheck;
    IBOutlet NSButton *cursorCheck;
    IBOutlet NSButton *cursorBlinkCheck;
}
- (IBAction)contrastChanged:(id)sender;
- (IBAction)backlightChecked:(id)sender;
- (IBAction)cursorChecked:(id)sender;
- (IBAction)cursorBlinkChecked:(id)sender;
- (void)phidgetAdded;
- (void)phidgetRemoved;
- (void)setPicture:(int)version:(CPhidget_DeviceID)devid;
@end
