/* PhidggetTemperatureSensorController */

#import <Cocoa/Cocoa.h>
#include <Phidget21/phidget21.h>

@interface PhidggetTemperatureSensorController : NSObject
{
    IBOutlet NSTextField *connectedField;
    IBOutlet NSTextField *numInputsField;
    IBOutlet NSTextField *serialField;
    IBOutlet NSTextField *temp0Field;
    IBOutlet NSTextField *temp1Field;
    IBOutlet NSTextField *potentialField;
    IBOutlet NSTextField *versionField;
    IBOutlet NSTextField *temperatureRangeField;
    IBOutlet NSTextField *potentialRangeField;
    IBOutlet NSTextField *triggerField;
	IBOutlet id mainWindow;
	IBOutlet NSImageView *pictureBox;
    IBOutlet NSBox *sensorBox;
    IBOutlet NSBox *settingsBox;
}
- (IBAction)setChangeTrigger:(id)sender;
- (IBAction)choseThermocoupleType:(id)sender;
- (void)phidgetAdded;
- (void)phidgetRemoved;
- (void)setPicture:(int)version:(CPhidget_DeviceID)devid;
- (void)gotTemperatureChange:(int)Index:(double)Value;
@end
