#import "PhidgetRFIDController.h"

CPhidgetRFIDHandle rfid=0;

@implementation PhidgetRFIDController

int gotAttach(CPhidgetHandle phid, void *context) {
	[(id)context phidgetAdded];
	return 0;
}

int gotDetach(CPhidgetHandle phid, void *context) {
	[(id)context phidgetRemoved];
	return 0;
}

int gotTag(CPhidgetRFIDHandle phid, void *context, unsigned char *tag) {
	[(id)context RFIDTag:tag];
	return 0;
}

int lostTag(CPhidgetRFIDHandle phid, void *context, unsigned char *tag) {
	[(id)context RFIDTagLost];
	return 0;
}

- (void)phidgetAdded
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];

	int serial, version;
	int numOutputs;
	const char *name;
	CPhidget_DeviceID devid;
	int heightChange;

	CPhidget_getSerialNumber((CPhidgetHandle)rfid, &serial);
	CPhidget_getDeviceVersion((CPhidgetHandle)rfid, &version);
	CPhidget_getDeviceName((CPhidgetHandle)rfid, &name);
	CPhidget_getDeviceID((CPhidgetHandle)rfid, &devid);
	CPhidgetRFID_getOutputCount(rfid, &numOutputs);
	
	[connectedField setStringValue:[NSString stringWithCString:name]];
	[serialField setIntValue:serial];
	[versionField setIntValue:version];
	[numberOfOutputsField setIntValue:numOutputs];
	
	[antennaCheck setState:0];
	[externalLEDCheck setState:0];
	[fiveVCheck setState:0];
	[onboardLEDCheck setState:0];
	
	NSRect frame = [mainWindow frame];
	
	switch(devid)
	{
		case PHIDID_RFID_2OUTPUT:
			[settingsBox setHidden:FALSE];
			heightChange = frame.size.height - 343;
			
			//Turn on antenna and LED
			CPhidgetRFID_setLEDOn(rfid,1);
			CPhidgetRFID_setAntennaOn(rfid,1);
			[onboardLEDCheck setState:true];
			[antennaCheck setState:true];
			
			break;
		case PHIDID_RFID:
			[settingsBox setHidden:TRUE];
			heightChange = frame.size.height - 264;
			break;
		default:
			break;
	}
	
	[tagBox setHidden:FALSE];
	
	frame.origin.y += heightChange;
	frame.size.height -= heightChange;
	[mainWindow setMinSize:frame.size];
	[mainWindow setFrame:frame display:YES animate:NO];
	
	[self setPicture:version:devid];
	[pool release];
	[mainWindow display];
}

- (void)phidgetRemoved
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	[connectedField setStringValue:@"Nothing"];
	[serialField setStringValue:@""];
	[versionField setStringValue:@""];
	[numberOfOutputsField setStringValue:@""];
	
	[antennaCheck setState:0];
	[externalLEDCheck setState:0];
	[fiveVCheck setState:0];
	[onboardLEDCheck setState:0];
	
	[settingsBox setHidden:TRUE];
	[tagBox setHidden:TRUE];
	
	NSRect frame = [mainWindow frame];
	int heightChange = frame.size.height - 195;
	frame.origin.y += heightChange;
	frame.size.height -= heightChange;
	[mainWindow setMinSize:frame.size];
	[mainWindow setFrame:frame display:YES animate:NO];
	
	[self setPicture:0:0];
	
	[pool release];
	[mainWindow display];
}

/*
* got a tag
*/
- (void)RFIDTag:(unsigned char *)tag
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	[tagField setTitleWithMnemonic:[NSString stringWithFormat:@"%02x%02x%02x%02x%02x\n",tag[0],tag[1],tag[2],tag[3],tag[4]]];
	[pool release];
}

/*
* lost a tag
*/
- (void)RFIDTagLost
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	[tagField setTitleWithMnemonic:@""];
	[pool release];
}

- (IBAction)antennaChecked:(id)sender
{
	CPhidgetRFID_setAntennaOn(rfid,[sender state]);
}

- (IBAction)externalLEDChecked:(id)sender
{
	CPhidgetRFID_setOutputState(rfid, 1,[sender state]);
}

- (IBAction)fiveVChecked:(id)sender
{
	CPhidgetRFID_setOutputState(rfid, 0,[sender state]);
}

- (IBAction)onboardLEDChecked:(id)sender
{
	CPhidgetRFID_setLEDOn(rfid,[sender state]);
}

/*
* This gets run when the GUI gets displayed
*/
- (void)awakeFromNib
{
	int serial = -1, remote = 0;
	NSArray *args = [[NSProcessInfo processInfo] arguments];
	if([args count] > 1)
	{
		if([[args objectAtIndex:1] isEqualToString:@"remote"])
			remote = 1;
		serial = strtol([[args objectAtIndex:[args count]-1] UTF8String], NULL, 10);
		if(serial == 0) serial = -1;
	}
	
	[mainWindow setDelegate:self];
	
	[tagField setFont:[NSFont fontWithName:@"Courier New" size:14.0]];
	
	CPhidgetRFID_create(&rfid);
	
	CPhidgetRFID_set_OnTag_Handler(rfid, gotTag, self);
	CPhidgetRFID_set_OnTagLost_Handler(rfid, lostTag, self);
	CPhidget_set_OnAttach_Handler((CPhidgetHandle)rfid, gotAttach, self);
	CPhidget_set_OnDetach_Handler((CPhidgetHandle)rfid, gotDetach, self);
	
	if(remote)
		CPhidget_openRemote((CPhidgetHandle)rfid, serial, NULL, NULL);
	else
		CPhidget_open((CPhidgetHandle)rfid, serial);
}

- (void)windowWillClose:(NSNotification *)aNotification {
	CPhidget_close((CPhidgetHandle)rfid);
	CPhidget_delete((CPhidgetHandle)rfid);
	rfid = NULL;
	[NSApp terminate:self];
}

- (void)setPicture:(int)version:(CPhidget_DeviceID)devid
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	NSString *imgPath;
	
	switch(devid)
	{
		case PHIDID_RFID_2OUTPUT:
			imgPath = [[NSBundle bundleForClass:[self class]] pathForResource:@"1023_1" ofType:@"icns"];
			break;
		case PHIDID_RFID:
		default:
			imgPath = nil;
			break;
	}
	
	NSImage *img = [[NSImage alloc]  initByReferencingFile:imgPath];
	
	//otherwise the images are just painted over each other - and the transparency causes trouble
	[pictureBox setImage:nil];
	[pictureBox display];
	if(imgPath!=nil)
		[NSApp setApplicationIconImage: img];
	[pictureBox setImage:img];
	[pictureBox display];
	
	[pool release];
}
@end
