/* PhidgetMotorController */

#import <Cocoa/Cocoa.h>
#include <Phidget21/phidget21.h>

@interface PhidgetMotorController : NSObject
{
    IBOutlet NSTextField *connectedField;
    IBOutlet id inputs;
    IBOutlet NSTextField *numInputsField;
    IBOutlet NSTextField *numMotorsField;
    IBOutlet NSTextField *serialField;
    IBOutlet NSSlider *accel0Slider;
    IBOutlet NSSlider *accel1Slider;
    IBOutlet NSTextField *setAccel0Field;
    IBOutlet NSTextField *setAccel1Field;
    IBOutlet NSTextField *setSpeed0Field;
    IBOutlet NSTextField *setSpeed1Field;
    IBOutlet NSTextField *speed0Field;
    IBOutlet NSTextField *speed1Field;
	IBOutlet NSSlider *speed0Slider;
	IBOutlet NSSlider *speed1Slider;
    IBOutlet NSTextField *current0Field;
    IBOutlet NSTextField *current1Field;
    IBOutlet NSSlider *current0Slider;
    IBOutlet NSSlider *current1Slider;
	IBOutlet NSTextField *currentLabel;
    IBOutlet NSTextField *versionField;
    IBOutlet NSBox *motorsetBox;
    IBOutlet NSBox *motorstateBox;
    IBOutlet NSBox *inputBox;
	IBOutlet NSImageView *pictureBox;
	IBOutlet id mainWindow;
}
- (IBAction)accel0:(id)sender;
- (IBAction)accel1:(id)sender;
- (IBAction)speed0:(id)sender;
- (IBAction)speed1:(id)sender;
- (void)phidgetAdded;
- (void)phidgetRemoved;
- (void)InputChange:(int)Index:(int)State;
- (void)MotorChange:(int)Index:(double)Value;
- (void)CurrentChange:(int)Index:(double)Value;
- (void)setPicture:(int)version:(CPhidget_DeviceID)devid;
@end
