/* PhidgetInterfaceKitController */

#import <Cocoa/Cocoa.h>
#include <Phidget21/phidget21.h>

@interface PhidgetInterfaceKitController : NSObject
{
    IBOutlet NSTextField *connectedField;
    IBOutlet NSMatrix *inputLabels;
    IBOutlet NSMatrix *inputs;
    IBOutlet NSBox *inputsBox;
    IBOutlet NSWindow *mainWindow;
    IBOutlet NSTextField *numInputsField;
    IBOutlet NSTextField *numOutputsField;
    IBOutlet NSTextField *numSensorsField;
    IBOutlet NSMatrix *outputLabels;
    IBOutlet NSMatrix *outputs;
    IBOutlet NSBox *outputsBox;
    IBOutlet NSImageView *pictureBox;
    IBOutlet NSButton *ratiometric;
    IBOutlet NSTextField *sensitivityField;
    IBOutlet NSSlider *sensitivitySlider;
    IBOutlet NSBox *sensorsBox;
    IBOutlet NSMatrix *sensorFields;
    IBOutlet NSMatrix *sensorLabels;
    IBOutlet NSMatrix *sensorSliders;
    IBOutlet NSTextField *serialField;
    IBOutlet NSTextField *versionField;
	IBOutlet NSBox *phidgetBox;
}
- (IBAction)output:(id)sender;
- (IBAction)ratiometric:(id)sender;
- (IBAction)sensitivity:(id)sender;
- (void)OutputChange:(int)Index:(int)State;
- (void)InputChange:(int)Index:(int)State;
- (void)SensorChange:(int)Index:(int)Value;
- (void)phidgetAdded;
- (void)phidgetRemoved;
@end
