//
//  AccelView.m
//  CocoaAccelerometer
//
//  Created by Allanon on 09/11/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import "GyroView.h"
#import <ApplicationServices/ApplicationServices.h>

#define PI M_PI /* From <math.h>. */

/* A convenience function to get a CGRect from an NSRect. You can also use
 * the *(CGRect *)&nsRect sleight-of-hand, but this way is clearer. */

static inline CGRect
convertToCGRect(NSRect rect)
{
    return CGRectMake(rect.origin.x, rect.origin.y,
		      rect.size.width, rect.size.height);
}

@implementation GyroView

- (void)setX:(double)number{
	xaxis = number;
}

- (void)setY:(double)number{
	yaxis = number;
}

- (void)setZ:(double)number{
	zaxis = number;
}

- (id)initWithFrame:(NSRect)frameRect
{
    self = [super initWithFrame:frameRect];
    if (self == nil)
	return nil;

    xaxis = 0;
	yaxis = 0;
	zaxis = 0;
	
    return self;
}

- (void)drawRect:(NSRect)rect
{
    CGRect r;
    CGContextRef context;

    r = convertToCGRect(rect);
    context = [[NSGraphicsContext currentContext] graphicsPort];
    
	[self circles:context:r];
}

-(void) circles:(CGContextRef)context:(CGRect)rect
{
    float w, h, r;

    /* Draw a cricle */
	w = CGRectGetWidth(rect);
	h = CGRectGetHeight(rect);
	r = (w < h) ? w/2.5 : h/2.5;
	
	CGContextBeginPath(context);
	
	CGContextSetRGBStrokeColor(context, 1.0, 0, 0, 1);
	CGContextAddArc(context, CGRectGetMidX(rect), CGRectGetMidY(rect), r, (xaxis+2)*(PI/180), (xaxis-2)*(PI/180), false);
	CGContextStrokePath(context);
	
	CGContextAddArc(context, r*cos(xaxis*(PI/180)) + CGRectGetMidX(rect), r*sin(xaxis*(PI/180)) + CGRectGetMidY(rect), 4, 0, 2*PI, false);
	CGContextSetRGBFillColor(context, 0, 0, 0, 1);
	CGContextFillPath(context);
	
	CGContextSetRGBStrokeColor(context, 0, 1.0, 0, 1);
	CGContextAddArc(context, CGRectGetMidX(rect), CGRectGetMidY(rect), r-10, (yaxis+2)*(PI/180), (yaxis-2)*(PI/180), false);
	CGContextStrokePath(context);
	
	CGContextAddArc(context, (r-10)*cos(yaxis*(PI/180)) + CGRectGetMidX(rect), (r-10)*sin(yaxis*(PI/180)) + CGRectGetMidY(rect), 4, 0, 2*PI, false);
	CGContextSetRGBFillColor(context, 0, 0, 0, 1);
	CGContextFillPath(context);
	
	CGContextSetRGBStrokeColor(context, 0, 0, 1.0, 1);
	CGContextAddArc(context, CGRectGetMidX(rect), CGRectGetMidY(rect), r-20, (zaxis+2)*(PI/180), (zaxis-2)*(PI/180), false);
	CGContextStrokePath(context);
	
	CGContextAddArc(context, (r-20)*cos(zaxis*(PI/180)) + CGRectGetMidX(rect), (r-20)*sin(zaxis*(PI/180)) + CGRectGetMidY(rect), 4, 0, 2*PI, false);
	CGContextSetRGBFillColor(context, 0, 0, 0, 1);
	CGContextFillPath(context);
	
	//CGContextClosePath(context);
}

@end
