#import "PhidgetGPSController.h"

CPhidgetGPSHandle gps=0;

@implementation PhidgetGPSController

int gotAttach(CPhidgetHandle phid, void *context) {
	[(id)context phidgetAdded];
	return 0;
}

int gotDetach(CPhidgetHandle phid, void *context) {
	[(id)context phidgetRemoved];
	return 0;
}

int gotPositionChange(CPhidgetGPSHandle phid, void *context, double latitude, double longitude, double altitude) {
	[(id)context gotPosition];
	return 0;
}

int gotNMEAData(CPhidgetGPSHandle phid, void *userPtr, const char *data) {
	printf("NMEA Data: %s\n", data);
	return 0;
}

- (void)phidgetAdded
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	
	int serial, version;
	
	CPhidget_getSerialNumber((CPhidgetHandle)gps, &serial);
	CPhidget_getDeviceVersion((CPhidgetHandle)gps, &version);
	
	[connectedField setTitleWithMnemonic:@"PhidgetGPS Connected"];
	[serialField setTitleWithMnemonic:[NSString stringWithFormat:@"%d", serial]];
	[versionField setTitleWithMnemonic:[NSString stringWithFormat:@"%d", version]];
	
	//set it to update even if the fix is bad
	CPhidgetGPS_setPositionChangeTrigger(gps, -1);

	[pool release];
}

- (void)phidgetRemoved
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	
	[connectedField setTitleWithMnemonic:@"PhidgetGPS Removed"];
	[serialField setTitleWithMnemonic:@""];
	[versionField setTitleWithMnemonic:@""];
	
	[pool release];
}

/*
* got a tag
*/
- (void)gotPosition
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	double speed;

	GPSInfo gpsData;
	GPSTime gpsTime;
	CPhidgetGPS_getRawData(gps, &gpsData);
	CPhidgetGPS_getTime(gps, &gpsTime);
	speed = gpsData.RMC.speed * 1.85200;
		
	switch(gpsData.GGA.fixQuality) {
	case 0:
		[statusField setTitleWithMnemonic:@"Invalid Fix"];
		break;
	case 1:
		[statusField setTitleWithMnemonic:@"Valid SPS Fix"];
		break;
	case 2:
		[statusField setTitleWithMnemonic:@"Valid DGPS Fix"];
		break;
	case 3:
		[statusField setTitleWithMnemonic:@"Valid PPS Fix"];
		break;
	default:
		[statusField setTitleWithMnemonic:@"Unknown Status"];
		break;
	}
	
	[latitudeField setTitleWithMnemonic:[NSString stringWithFormat:@"%f",gpsData.GGA.latitude]];
	[longitudeField setTitleWithMnemonic:[NSString stringWithFormat:@"%f",gpsData.GGA.longitude]];
	[altitudeField setTitleWithMnemonic:[NSString stringWithFormat:@"%f",gpsData.GGA.altitude]];
	[headingField setTitleWithMnemonic:[NSString stringWithFormat:@"%f",gpsData.RMC.heading]];
	[speedField setTitleWithMnemonic:[NSString stringWithFormat:@"%f",speed]];
	[timeField setTitleWithMnemonic:[NSString stringWithFormat:@"%02d:%02d:%02d   %02d/%02d/%02d",
		gpsTime.tm_hour,gpsTime.tm_min,gpsTime.tm_sec,gpsData.RMC.date.tm_mday,gpsData.RMC.date.tm_mon,gpsData.RMC.date.tm_year]];

	NSTextStorage *textStorage;
	NSAttributedString *string = [NSAttributedString alloc];
	[string initWithString:[NSString stringWithFormat:@"%f,%f,%f\n",gpsData.GGA.longitude,gpsData.GGA.latitude,gpsData.GGA.altitude]];
	textStorage = [[logField documentView] textStorage];
	[textStorage beginEditing];
	[textStorage appendAttributedString:string];
	[textStorage endEditing];
	
	[pool release];
}


/*
* This gets run when the GUI gets displayed
*/
- (void)awakeFromNib
{
	int serial = -1;
	NSArray *args = [[NSProcessInfo processInfo] arguments];
	if([args count] > 1)
	{
		NSString *serialString = [args objectAtIndex:1];
		serial = strtol([serialString UTF8String], NULL, 10);
		if(serial == 0) serial = -1;
	}
	
	[mainWindow setDelegate:self];
	
	CPhidget_enableLogging(PHIDGET_LOG_VERBOSE, NULL);
	
	CPhidgetGPS_create(&gps);
	
	CPhidgetGPS_set_OnNMEAData_Handler(gps, gotNMEAData, self);
	CPhidgetGPS_set_OnPositionChange_Handler(gps, gotPositionChange, self);
	CPhidget_set_OnAttach_Handler((CPhidgetHandle)gps, gotAttach, self);
	CPhidget_set_OnDetach_Handler((CPhidgetHandle)gps, gotDetach, self);
	
	CPhidget_open((CPhidgetHandle)gps, serial);
}

- (void)windowWillClose:(NSNotification *)aNotification {
	CPhidget_close((CPhidgetHandle)gps);
	CPhidget_delete((CPhidgetHandle)gps);
	gps = NULL;
	[NSApp terminate:self];
}@end
