/*
 * Decompiled with CFR 0.152.
 */
package listeners;

import com.phidgets.PhidgetException;
import com.phidgets.RFIDPhidget;
import com.phidgets.event.AttachEvent;
import com.phidgets.event.AttachListener;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class RFIDAttachListener
implements AttachListener {
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numOutputsTxt;
    private JCheckBox antennaChk;
    private JCheckBox ledChk;
    private JCheckBox out0Chk;
    private JCheckBox out1Chk;

    public RFIDAttachListener(JFrame appFrame, JTextField attachedTxt, JTextArea nameTxt, JTextField serialTxt, JTextField versionTxt, JTextField numOutputsTxt, JCheckBox antennaChk, JCheckBox ledChk, JCheckBox out0Chk, JCheckBox out1Chk) {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numOutputsTxt = numOutputsTxt;
        this.antennaChk = antennaChk;
        this.ledChk = ledChk;
        this.out0Chk = out0Chk;
        this.out1Chk = out1Chk;
    }

    public void attached(AttachEvent ae) {
        try {
            RFIDPhidget attached = (RFIDPhidget)ae.getSource();
            this.attachedTxt.setText(Boolean.toString(attached.isAttached()));
            this.nameTxt.setText(attached.getDeviceName());
            this.serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            this.versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
            this.numOutputsTxt.setText(Integer.toString(attached.getOutputCount()));
            this.antennaChk.setEnabled(true);
            attached.setAntennaOn(true);
            this.antennaChk.setSelected(true);
            this.ledChk.setEnabled(true);
            this.ledChk.setSelected(attached.getLEDOn());
            this.out0Chk.setEnabled(true);
            this.out0Chk.setSelected(attached.getOutputState(0));
            this.out1Chk.setEnabled(true);
            this.out1Chk.setSelected(attached.getOutputState(1));
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this.appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), 0);
        }
    }
}

