/*
 * Decompiled with CFR 0.152.
 */
package listeners;

import Math.Matrix3x3;
import Math.Vector3;
import com.phidgets.PhidgetException;
import com.phidgets.SpatialEventData;
import com.phidgets.SpatialPhidget;
import com.phidgets.event.SpatialDataEvent;
import com.phidgets.event.SpatialDataListener;
import graphics.CompassBearingGraphPanel;
import graphics.GyroGraphPanel;
import graphics.MagFieldGraphPanel;
import graphics.MotionGraphPanel;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpatialSpatialDataListener
implements SpatialDataListener {
    private JTextField accelXTxt;
    private JTextField accelYTxt;
    private JTextField accelZTxt;
    private JTextField gyroXTxt;
    private JTextField gyroYTxt;
    private JTextField gyroZTxt;
    private JTextField gyroXTxt1;
    private JTextField gyroYTxt1;
    private JTextField gyroZTxt1;
    private Double[] gyroHeading;
    private Double lastTime;
    private JTextField pitchAngleTxt;
    private JTextField rollAngleTxt;
    private JTextField bearingTxt;
    private ArrayList<Double[]> compassBearingFilter;
    private MotionGraphPanel graphPanel;
    private MagFieldGraphPanel magFieldGraphPanel;
    private GyroGraphPanel gyroGraphPanel;
    private double compassBearing;
    private CompassBearingGraphPanel compassBearingGraphPanel;
    private final char DEGREESYMBOL = (char)176;
    double lastBearing = 0.0;

    public SpatialSpatialDataListener(JTextField accelXTxt, JTextField accelYTxt, JTextField accelZTxt, JTextField gyroXTxt, JTextField gyroYTxt, JTextField gyroZTxt, JTextField gyroXTxt1, JTextField gyroYTxt1, JTextField gyroZTxt1, Double[] gyroHeading, Double lastTime, JTextField pitchAngleTxt, JTextField rollAngleTxt, JTextField bearingTxt, ArrayList<Double[]> compassBearingFilter, MotionGraphPanel graphPanel, MagFieldGraphPanel magFieldGraphPanel, GyroGraphPanel gyroGraphPanel, CompassBearingGraphPanel compassBearingGraphPanel) {
        this.accelXTxt = accelXTxt;
        this.accelYTxt = accelYTxt;
        this.accelZTxt = accelZTxt;
        this.gyroXTxt = gyroXTxt;
        this.gyroYTxt = gyroYTxt;
        this.gyroZTxt = gyroZTxt;
        this.gyroXTxt1 = gyroXTxt1;
        this.gyroYTxt1 = gyroYTxt1;
        this.gyroZTxt1 = gyroZTxt1;
        this.gyroHeading = gyroHeading;
        this.lastTime = lastTime;
        this.pitchAngleTxt = pitchAngleTxt;
        this.rollAngleTxt = rollAngleTxt;
        this.bearingTxt = bearingTxt;
        this.compassBearingFilter = compassBearingFilter;
        this.graphPanel = graphPanel;
        this.magFieldGraphPanel = magFieldGraphPanel;
        this.gyroGraphPanel = gyroGraphPanel;
        this.compassBearingGraphPanel = compassBearingGraphPanel;
        this.compassBearing = 0.0;
    }

    public Double getLastTime() {
        return this.lastTime;
    }

    @Override
    public void data(SpatialDataEvent sde) {
        SpatialPhidget spatial = (SpatialPhidget)sde.getSource();
        try {
            if (spatial.getAccelerationAxisCount() > 0) {
                this.accelXTxt.setText(Double.toString(this.roundDouble(sde.getData()[0].getAcceleration()[0], 3)));
                this.accelYTxt.setText(Double.toString(this.roundDouble(sde.getData()[0].getAcceleration()[1], 3)));
                this.accelZTxt.setText(Double.toString(this.roundDouble(sde.getData()[0].getAcceleration()[2], 3)));
                this.displayAccelGraph(sde.getData()[0].getAcceleration(), this.graphPanel);
            }
        }
        catch (PhidgetException ex) {
            Logger.getLogger(SpatialSpatialDataListener.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            if (spatial.getGyroAxisCount() > 0) {
                this.calculateGyroHeading(sde.getData());
                this.gyroXTxt.setText(Double.toString(this.roundDouble(this.gyroHeading[0], 3)) + '\u00b0');
                this.gyroYTxt.setText(Double.toString(this.roundDouble(this.gyroHeading[1], 3)) + '\u00b0');
                this.gyroZTxt.setText(Double.toString(this.roundDouble(this.gyroHeading[2], 3)) + '\u00b0');
                this.displayGyroGraph(this.gyroGraphPanel);
            }
        }
        catch (PhidgetException ex) {
            Logger.getLogger(SpatialSpatialDataListener.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            if (spatial.getCompassAxisCount() > 0 && sde.getData()[0].getMagneticField().length > 0) {
                this.gyroXTxt1.setText(Double.toString(this.roundDouble(sde.getData()[0].getMagneticField()[0], 3)));
                this.gyroYTxt1.setText(Double.toString(this.roundDouble(sde.getData()[0].getMagneticField()[1], 3)));
                this.gyroZTxt1.setText(Double.toString(this.roundDouble(sde.getData()[0].getMagneticField()[2], 3)));
                try {
                    this.displayMagFieldGraph(sde.getData()[0].getMagneticField(), this.magFieldGraphPanel);
                    this.calculateCompassBearing(sde.getData());
                    this.displayCompassBearingGraph(this.compassBearingGraphPanel);
                }
                catch (Exception ex) {}
            }
        }
        catch (PhidgetException ex) {
            Logger.getLogger(SpatialSpatialDataListener.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void calculateGyroHeading(SpatialEventData[] data) {
        Double time = data[0].getTime() * 1000.0;
        if (this.lastTime == 0.0) {
            this.lastTime = time;
        }
        for (int i = 0; i < 3; ++i) {
            Double[] doubleArray = this.gyroHeading;
            int n = i;
            Double.valueOf(doubleArray[n] + data[0].getAngularRate()[i] * ((time - this.lastTime) / 1000.0));
        }
        this.lastTime = time;
    }

    public void calculateCompassBearing(SpatialEventData[] spatialData) {
        double Xh = 0.0;
        double Yh = 0.0;
        Vector3 gravity = Vector3.Normalize(new Vector3(spatialData[0].getAcceleration()[0], spatialData[0].getAcceleration()[2], spatialData[0].getAcceleration()[1]));
        double pitchAngle = Math.asin(gravity.X);
        double rollAngle = Math.asin(gravity.Z);
        if (gravity.Y < 0.0) {
            pitchAngle = -pitchAngle;
            rollAngle = -rollAngle;
        }
        Matrix3x3 xRotMatrix = new Matrix3x3();
        xRotMatrix.matrix[0][0] = Math.cos(pitchAngle);
        xRotMatrix.matrix[1][0] = -Math.sin(pitchAngle);
        xRotMatrix.matrix[2][0] = 0.0;
        xRotMatrix.matrix[0][1] = Math.sin(pitchAngle);
        xRotMatrix.matrix[1][1] = Math.cos(pitchAngle);
        xRotMatrix.matrix[2][1] = 0.0;
        xRotMatrix.matrix[0][2] = 0.0;
        xRotMatrix.matrix[1][2] = 0.0;
        xRotMatrix.matrix[2][2] = 1.0;
        Matrix3x3 zRotMatrix = new Matrix3x3();
        zRotMatrix.matrix[0][0] = 1.0;
        zRotMatrix.matrix[1][0] = 0.0;
        zRotMatrix.matrix[2][0] = 0.0;
        zRotMatrix.matrix[0][1] = 0.0;
        zRotMatrix.matrix[1][1] = Math.cos(rollAngle);
        zRotMatrix.matrix[2][1] = -Math.sin(rollAngle);
        zRotMatrix.matrix[0][2] = 0.0;
        zRotMatrix.matrix[1][2] = Math.sin(rollAngle);
        zRotMatrix.matrix[2][2] = Math.cos(rollAngle);
        Matrix3x3 rotMatrix = Matrix3x3.Multiply(xRotMatrix, zRotMatrix);
        Vector3 data = new Vector3(spatialData[0].getMagneticField()[0], spatialData[0].getMagneticField()[2], -spatialData[0].getMagneticField()[1]);
        Vector3 correctedData = Matrix3x3.Multiply(data, rotMatrix);
        Xh = -correctedData.Z;
        Yh = -correctedData.X;
        try {
            double bearing = 0.0;
            double _360inRads = Math.PI * 2;
            if (Xh < 0.0) {
                bearing = Math.PI - Math.atan(Yh / Xh);
            } else if (Xh > 0.0 && Yh < 0.0) {
                bearing = -Math.atan(Yh / Xh);
            } else if (Xh > 0.0 && Yh > 0.0) {
                bearing = Math.PI * 2 - Math.atan(Yh / Xh);
            } else if (Xh == 0.0 && Yh < 0.0) {
                bearing = 1.5707963267948966;
            } else if (Xh == 0.0 && Yh > 0.0) {
                bearing = 4.71238898038469;
            }
            if (gravity.Y < 0.0) {
                bearing = Math.abs(bearing - _360inRads);
            }
            if (Math.abs(bearing - this.lastBearing) > 2.0) {
                Double[] doubleArray;
                Double[] stuff;
                Iterator<Double[]> i$;
                if (bearing > this.lastBearing) {
                    i$ = this.compassBearingFilter.iterator();
                    while (i$.hasNext()) {
                        doubleArray = stuff = i$.next();
                        Double.valueOf(doubleArray[0] + _360inRads);
                    }
                } else {
                    i$ = this.compassBearingFilter.iterator();
                    while (i$.hasNext()) {
                        doubleArray = stuff = i$.next();
                        Double.valueOf(doubleArray[0] - _360inRads);
                    }
                }
            }
            Double[] temp = new Double[]{bearing, pitchAngle, rollAngle};
            int compassBearingFilterSize = 10;
            this.compassBearingFilter.add(temp);
            if (this.compassBearingFilter.size() > compassBearingFilterSize) {
                this.compassBearingFilter.remove(0);
            }
            bearing = 0.0;
            pitchAngle = 0.0;
            rollAngle = 0.0;
            for (Double[] stuff : this.compassBearingFilter) {
                bearing += stuff[0].doubleValue();
                pitchAngle += stuff[1].doubleValue();
                rollAngle += stuff[2].doubleValue();
            }
            this.compassBearing = (bearing /= (double)this.compassBearingFilter.size()) * 57.29577951308232;
            this.lastBearing = bearing;
            this.bearingTxt.setText(Double.toString(this.roundDouble(bearing * 57.29577951308232, 1)) + '\u00b0');
            this.pitchAngleTxt.setText(Double.toString(this.roundDouble((pitchAngle /= (double)this.compassBearingFilter.size()) * 57.29577951308232, 1)) + '\u00b0');
            this.rollAngleTxt.setText(Double.toString(this.roundDouble((rollAngle /= (double)this.compassBearingFilter.size()) * 57.29577951308232, 1)) + '\u00b0');
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private void displayAccelGraph(double[] accelData, MotionGraphPanel graphPanel) {
        graphPanel.setXOut(accelData[0]);
        graphPanel.setYOut(accelData[1]);
        graphPanel.setZOut(accelData[2]);
        graphPanel.repaint();
    }

    private void displayMagFieldGraph(double[] magFieldData, MagFieldGraphPanel graphPanel) {
        graphPanel.setXOut(magFieldData[0]);
        graphPanel.setYOut(magFieldData[1]);
        graphPanel.setZOut(magFieldData[2]);
        graphPanel.repaint();
    }

    private void displayGyroGraph(GyroGraphPanel graphPanel) {
        graphPanel.setXOut(this.gyroHeading[0]);
        graphPanel.setYOut(this.gyroHeading[1]);
        graphPanel.setZOut(this.gyroHeading[2]);
        graphPanel.repaint();
    }

    private void displayCompassBearingGraph(CompassBearingGraphPanel graphPanel) {
        graphPanel.setCompassBearing(this.compassBearing);
        graphPanel.repaint();
    }

    private double roundDouble(Double value, int decimalPlaces) {
        BigDecimal bd = new BigDecimal(value).setScale(decimalPlaces, RoundingMode.HALF_EVEN);
        return bd.doubleValue();
    }
}

