/*
 * Decompiled with CFR 0.152.
 */
package Spatial;

import com.phidgets.PhidgetException;
import com.phidgets.SpatialPhidget;
import graphics.CompassBearingGraphPanel;
import graphics.GyroGraphPanel;
import graphics.MagFieldGraphPanel;
import graphics.MotionGraphPanel;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import listeners.SpatialAttachListener;
import listeners.SpatialDetachListener;
import listeners.SpatialErrorListener;
import listeners.SpatialSpatialDataListener;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class Spatial
extends JFrame {
    private static String[] runArgs;
    private SpatialPhidget spatial;
    private SpatialAttachListener attach_listener;
    private SpatialDetachListener detach_listener;
    private SpatialErrorListener error_listener;
    private SpatialSpatialDataListener spatialData_listener;
    private MotionGraphPanel graphPanel;
    private MagFieldGraphPanel magFieldGraphPanel;
    private GyroGraphPanel gyroGraphPanel;
    private CompassBearingGraphPanel compassBearingGraphPanel;
    private Double[] gyroHeading = new Double[]{0.0, 0.0, 0.0};
    private Double lastTime;
    private ArrayList<Double[]> compassBearingFilter = new ArrayList();
    private JTextField accelXTxt;
    private JTextField accelYTxt;
    private JTextField accelZTxt;
    private JTextField attachedTxt;
    private JTextField bearingTxt;
    private JSlider dataRateScrl;
    private JTextField dataRateTxt;
    private JTextField gyroXTxt;
    private JTextField gyroXTxt1;
    private JTextField gyroYTxt;
    private JTextField gyroYTxt1;
    private JTextField gyroZTxt;
    private JTextField gyroZTxt1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JTextArea nameTxt;
    private JTextField numAccelAxesTxt;
    private JTextField numCompassAxesTxt;
    private JTextField numGyroAxesTxt;
    private JTextField pitchAngleTxt;
    private JTextField rollAngleTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JButton zeroGyroBtn;

    public Spatial() {
        this.initComponents();
        this.initCustomComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.attachedTxt = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.nameTxt = new JTextArea();
        this.jLabel2 = new JLabel();
        this.serialTxt = new JTextField();
        this.jLabel3 = new JLabel();
        this.versionTxt = new JTextField();
        this.jLabel4 = new JLabel();
        this.numAccelAxesTxt = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.numGyroAxesTxt = new JTextField();
        this.jLabel7 = new JLabel();
        this.numCompassAxesTxt = new JTextField();
        this.jPanel2 = new JPanel();
        this.dataRateScrl = new JSlider();
        this.dataRateTxt = new JTextField();
        this.jPanel3 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.accelXTxt = new JTextField();
        this.accelYTxt = new JTextField();
        this.accelZTxt = new JTextField();
        this.jPanel4 = new JPanel();
        this.jLabel11 = new JLabel();
        this.gyroXTxt = new JTextField();
        this.jLabel12 = new JLabel();
        this.gyroYTxt = new JTextField();
        this.jLabel13 = new JLabel();
        this.gyroZTxt = new JTextField();
        this.zeroGyroBtn = new JButton();
        this.jPanel5 = new JPanel();
        this.jLabel14 = new JLabel();
        this.gyroXTxt1 = new JTextField();
        this.jLabel15 = new JLabel();
        this.gyroYTxt1 = new JTextField();
        this.jLabel16 = new JLabel();
        this.gyroZTxt1 = new JTextField();
        this.pitchAngleTxt = new JTextField();
        this.rollAngleTxt = new JTextField();
        this.bearingTxt = new JTextField();
        this.jLabel17 = new JLabel();
        this.jLabel18 = new JLabel();
        this.jLabel19 = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("Spatial-full");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                Spatial.this.formWindowClosed(evt);
            }

            public void windowOpened(WindowEvent evt) {
                Spatial.this.formWindowOpened(evt);
            }
        });
        this.getContentPane().setLayout(new AbsoluteLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Spatial Info"));
        this.jPanel1.setLayout(new AbsoluteLayout());
        this.attachedTxt.setEditable(false);
        this.jPanel1.add((Component)this.attachedTxt, new AbsoluteConstraints(72, 22, 223, -1));
        this.jLabel1.setText("Attached:");
        this.jPanel1.add((Component)this.jLabel1, new AbsoluteConstraints(18, 25, -1, -1));
        this.nameTxt.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
        this.nameTxt.setColumns(20);
        this.nameTxt.setEditable(false);
        this.nameTxt.setLineWrap(true);
        this.nameTxt.setRows(3);
        this.nameTxt.setTabSize(2);
        this.nameTxt.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.nameTxt);
        this.jPanel1.add((Component)this.jScrollPane1, new AbsoluteConstraints(72, 48, 223, -1));
        this.jLabel2.setText("Name:");
        this.jPanel1.add((Component)this.jLabel2, new AbsoluteConstraints(18, 48, -1, -1));
        this.serialTxt.setEditable(false);
        this.jPanel1.add((Component)this.serialTxt, new AbsoluteConstraints(72, 114, 223, -1));
        this.jLabel3.setText("Serial No.:");
        this.jPanel1.add((Component)this.jLabel3, new AbsoluteConstraints(18, 117, -1, -1));
        this.versionTxt.setEditable(false);
        this.jPanel1.add((Component)this.versionTxt, new AbsoluteConstraints(72, 140, 223, -1));
        this.jLabel4.setText("Version:");
        this.jPanel1.add((Component)this.jLabel4, new AbsoluteConstraints(18, 143, -1, -1));
        this.numAccelAxesTxt.setEditable(false);
        this.jPanel1.add((Component)this.numAccelAxesTxt, new AbsoluteConstraints(125, 166, 170, -1));
        this.jLabel5.setText("Acceleration Axes:");
        this.jPanel1.add((Component)this.jLabel5, new AbsoluteConstraints(18, 169, -1, -1));
        this.jLabel6.setText("Gyro Axes:");
        this.jPanel1.add((Component)this.jLabel6, new AbsoluteConstraints(18, 195, -1, -1));
        this.numGyroAxesTxt.setEditable(false);
        this.jPanel1.add((Component)this.numGyroAxesTxt, new AbsoluteConstraints(125, 192, 170, -1));
        this.jLabel7.setText("Compass Axes:");
        this.jPanel1.add((Component)this.jLabel7, new AbsoluteConstraints(18, 221, -1, -1));
        this.numCompassAxesTxt.setEditable(false);
        this.jPanel1.add((Component)this.numCompassAxesTxt, new AbsoluteConstraints(125, 218, 170, -1));
        this.getContentPane().add((Component)this.jPanel1, new AbsoluteConstraints(10, 11, 313, 250));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Data Rate"));
        this.jPanel2.setLayout(new AbsoluteLayout());
        this.dataRateScrl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Spatial.this.dataRateScrlStateChanged(evt);
            }
        });
        this.jPanel2.add((Component)this.dataRateScrl, new AbsoluteConstraints(18, 33, 175, -1));
        this.dataRateTxt.setEditable(false);
        this.jPanel2.add((Component)this.dataRateTxt, new AbsoluteConstraints(259, 33, 36, -1));
        this.getContentPane().add((Component)this.jPanel2, new AbsoluteConstraints(10, 270, 313, 68));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Acceleration Data"));
        this.jPanel3.setLayout(new AbsoluteLayout());
        this.jLabel8.setText("X");
        this.jPanel3.add((Component)this.jLabel8, new AbsoluteConstraints(41, 25, 15, -1));
        this.jLabel9.setText("Y");
        this.jPanel3.add((Component)this.jLabel9, new AbsoluteConstraints(41, 51, 15, -1));
        this.jLabel10.setText("Z");
        this.jPanel3.add((Component)this.jLabel10, new AbsoluteConstraints(41, 77, 15, -1));
        this.accelXTxt.setEditable(false);
        this.jPanel3.add((Component)this.accelXTxt, new AbsoluteConstraints(60, 22, 67, -1));
        this.accelYTxt.setEditable(false);
        this.jPanel3.add((Component)this.accelYTxt, new AbsoluteConstraints(60, 48, 67, -1));
        this.accelZTxt.setEditable(false);
        this.jPanel3.add((Component)this.accelZTxt, new AbsoluteConstraints(60, 74, 67, -1));
        this.getContentPane().add((Component)this.jPanel3, new AbsoluteConstraints(10, 350, 140, 110));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Gyro Data"));
        this.jPanel4.setLayout(new AbsoluteLayout());
        this.jLabel11.setText("X");
        this.jPanel4.add((Component)this.jLabel11, new AbsoluteConstraints(50, 25, -1, -1));
        this.gyroXTxt.setEditable(false);
        this.jPanel4.add((Component)this.gyroXTxt, new AbsoluteConstraints(70, 22, 67, -1));
        this.jLabel12.setText("Y");
        this.jPanel4.add((Component)this.jLabel12, new AbsoluteConstraints(50, 51, 17, -1));
        this.gyroYTxt.setEditable(false);
        this.jPanel4.add((Component)this.gyroYTxt, new AbsoluteConstraints(70, 48, 67, -1));
        this.jLabel13.setText("Z");
        this.jPanel4.add((Component)this.jLabel13, new AbsoluteConstraints(50, 77, 12, -1));
        this.gyroZTxt.setEditable(false);
        this.jPanel4.add((Component)this.gyroZTxt, new AbsoluteConstraints(70, 74, 67, -1));
        this.zeroGyroBtn.setText("Zero");
        this.zeroGyroBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Spatial.this.zeroGyroBtnActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.zeroGyroBtn, new AbsoluteConstraints(77, 100, -1, -1));
        this.getContentPane().add((Component)this.jPanel4, new AbsoluteConstraints(170, 350, 150, 130));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder("Compass Data"));
        this.jPanel5.setLayout(new AbsoluteLayout());
        this.jLabel14.setText("X");
        this.jPanel5.add((Component)this.jLabel14, new AbsoluteConstraints(18, 36, -1, -1));
        this.gyroXTxt1.setEditable(false);
        this.jPanel5.add((Component)this.gyroXTxt1, new AbsoluteConstraints(28, 33, 65, -1));
        this.jLabel15.setText("Y");
        this.jPanel5.add((Component)this.jLabel15, new AbsoluteConstraints(18, 62, -1, -1));
        this.gyroYTxt1.setEditable(false);
        this.jPanel5.add((Component)this.gyroYTxt1, new AbsoluteConstraints(28, 59, 65, -1));
        this.jLabel16.setText("Z");
        this.jPanel5.add((Component)this.jLabel16, new AbsoluteConstraints(18, 88, -1, -1));
        this.gyroZTxt1.setEditable(false);
        this.jPanel5.add((Component)this.gyroZTxt1, new AbsoluteConstraints(28, 85, 65, -1));
        this.pitchAngleTxt.setEditable(false);
        this.jPanel5.add((Component)this.pitchAngleTxt, new AbsoluteConstraints(217, 33, 78, -1));
        this.rollAngleTxt.setEditable(false);
        this.jPanel5.add((Component)this.rollAngleTxt, new AbsoluteConstraints(217, 59, 78, -1));
        this.bearingTxt.setEditable(false);
        this.jPanel5.add((Component)this.bearingTxt, new AbsoluteConstraints(217, 85, 78, -1));
        this.jLabel17.setText("Pitch Angle");
        this.jPanel5.add((Component)this.jLabel17, new AbsoluteConstraints(145, 36, -1, -1));
        this.jLabel18.setText("Roll Angle");
        this.jPanel5.add((Component)this.jLabel18, new AbsoluteConstraints(145, 62, -1, -1));
        this.jLabel19.setText("Bearing");
        this.jPanel5.add((Component)this.jLabel19, new AbsoluteConstraints(145, 88, -1, -1));
        this.getContentPane().add((Component)this.jPanel5, new AbsoluteConstraints(10, 490, 313, 120));
        this.pack();
    }

    private void initCustomComponents() {
        this.graphPanel = new MotionGraphPanel();
        this.graphPanel.setBorder(BorderFactory.createTitledBorder("Acceleration Vector"));
        this.graphPanel.setLayout(new AbsoluteLayout());
        this.getContentPane().add((Component)this.graphPanel, new AbsoluteConstraints(335, 11, 290, 290));
        this.graphPanel.setVisible(false);
        this.graphPanel.setEnabled(false);
        this.magFieldGraphPanel = new MagFieldGraphPanel();
        this.magFieldGraphPanel.setBorder(BorderFactory.createTitledBorder("Magnectic Field Vector"));
        this.magFieldGraphPanel.setLayout(new AbsoluteLayout());
        this.getContentPane().add((Component)this.magFieldGraphPanel, new AbsoluteConstraints(640, 11, 290, 290));
        this.magFieldGraphPanel.setVisible(false);
        this.magFieldGraphPanel.setEnabled(false);
        this.gyroGraphPanel = new GyroGraphPanel();
        this.gyroGraphPanel.setBorder(BorderFactory.createTitledBorder("Gyroscope Headings"));
        this.gyroGraphPanel.setLayout(new AbsoluteLayout());
        this.getContentPane().add((Component)this.gyroGraphPanel, new AbsoluteConstraints(335, 300, 290, 290));
        this.gyroGraphPanel.setVisible(false);
        this.gyroGraphPanel.setEnabled(false);
        this.compassBearingGraphPanel = new CompassBearingGraphPanel();
        this.compassBearingGraphPanel.setBorder(BorderFactory.createTitledBorder("Compass Bearing"));
        this.compassBearingGraphPanel.setLayout(new AbsoluteLayout());
        this.getContentPane().add((Component)this.compassBearingGraphPanel, new AbsoluteConstraints(640, 300, 290, 290));
        this.compassBearingGraphPanel.setVisible(false);
        this.compassBearingGraphPanel.setEnabled(false);
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        try {
            this.spatial = new SpatialPhidget();
            this.gyroHeading[0] = 0.0;
            this.gyroHeading[1] = 0.0;
            this.gyroHeading[2] = 0.0;
            this.lastTime = 0.0;
            this.dataRateScrl.setEnabled(false);
            this.dataRateTxt.setEnabled(false);
            this.accelXTxt.setEnabled(false);
            this.accelYTxt.setEnabled(false);
            this.accelZTxt.setEnabled(false);
            this.gyroXTxt.setEnabled(false);
            this.gyroYTxt.setEnabled(false);
            this.gyroZTxt.setEnabled(false);
            this.zeroGyroBtn.setEnabled(false);
            this.gyroXTxt1.setEnabled(false);
            this.gyroYTxt1.setEnabled(false);
            this.gyroZTxt1.setEnabled(false);
            this.pitchAngleTxt.setEnabled(false);
            this.rollAngleTxt.setEnabled(false);
            this.bearingTxt.setEnabled(false);
            this.attach_listener = new SpatialAttachListener(this, this.jPanel2, this.jPanel3, this.jPanel4, this.jPanel5, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numAccelAxesTxt, this.numGyroAxesTxt, this.numCompassAxesTxt, this.dataRateScrl, this.dataRateTxt, this.accelXTxt, this.accelYTxt, this.accelZTxt, this.gyroXTxt, this.gyroYTxt, this.gyroZTxt, this.zeroGyroBtn, this.gyroXTxt1, this.gyroYTxt1, this.gyroZTxt1, this.pitchAngleTxt, this.rollAngleTxt, this.bearingTxt, this.gyroHeading, this.lastTime, this.graphPanel, this.magFieldGraphPanel, this.gyroGraphPanel, this.compassBearingGraphPanel);
            this.detach_listener = new SpatialDetachListener(this, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numAccelAxesTxt, this.numGyroAxesTxt, this.numCompassAxesTxt, this.dataRateScrl, this.dataRateTxt, this.accelXTxt, this.accelYTxt, this.accelZTxt, this.gyroXTxt, this.gyroYTxt, this.gyroZTxt, this.zeroGyroBtn, this.gyroXTxt1, this.gyroYTxt1, this.gyroZTxt1, this.pitchAngleTxt, this.rollAngleTxt, this.bearingTxt, this.gyroHeading, this.lastTime, this.graphPanel, this.magFieldGraphPanel, this.gyroGraphPanel, this.compassBearingGraphPanel);
            this.error_listener = new SpatialErrorListener(this);
            this.spatialData_listener = new SpatialSpatialDataListener(this.accelXTxt, this.accelYTxt, this.accelZTxt, this.gyroXTxt, this.gyroYTxt, this.gyroZTxt, this.gyroXTxt1, this.gyroYTxt1, this.gyroZTxt1, this.gyroHeading, this.lastTime, this.pitchAngleTxt, this.rollAngleTxt, this.bearingTxt, this.compassBearingFilter, this.graphPanel, this.magFieldGraphPanel, this.gyroGraphPanel, this.compassBearingGraphPanel);
            this.spatial.addAttachListener(this.attach_listener);
            this.spatial.addDetachListener(this.detach_listener);
            this.spatial.addErrorListener(this.error_listener);
            this.spatial.addSpatialDataListener(this.spatialData_listener);
            if (runArgs.length > 1 && runArgs[1].equals("remote")) {
                this.spatial.open(Integer.parseInt(runArgs[0]), null);
            } else if (runArgs.length > 0) {
                this.spatial.open(Integer.parseInt(runArgs[0]));
            } else {
                this.spatial.openAny();
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void formWindowClosed(WindowEvent evt) {
        try {
            this.spatial.removeSpatialDataListener(this.spatialData_listener);
            this.spatial.removeErrorListener(this.error_listener);
            this.spatial.removeDetachListener(this.detach_listener);
            this.spatial.removeAttachListener(this.attach_listener);
            this.spatial.close();
            this.spatial = null;
            this.dispose();
            System.exit(0);
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            this.dispose();
            System.exit(0);
        }
    }

    private void dataRateScrlStateChanged(ChangeEvent evt) {
        if (this.dataRateScrl.isEnabled()) {
            try {
                this.spatial.setDataRate(this.dataRateScrl.getValue());
                this.dataRateTxt.setText(Integer.toString(this.dataRateScrl.getValue()));
            }
            catch (PhidgetException phidgetException) {
                // empty catch block
            }
        }
    }

    private void zeroGyroBtnActionPerformed(ActionEvent evt) {
        try {
            this.spatial.zeroGyro();
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.gyroHeading[0] = 0.0;
        this.gyroHeading[1] = 0.0;
        this.gyroHeading[2] = 0.0;
    }

    public static void main(String[] args) {
        runArgs = args;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new Spatial().setVisible(true);
            }
        });
    }
}

