/*
 * Decompiled with CFR 0.152.
 */
package LED;

import com.phidgets.LEDPhidget;
import com.phidgets.PhidgetException;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import listeners.LEDAttachListener;
import listeners.LEDDetachListener;
import listeners.LEDErrorListener;
import org.jdesktop.layout.GroupLayout;

public class LED
extends JFrame {
    private static String[] runArgs;
    private LEDPhidget led;
    private LEDAttachListener attach_listener;
    private LEDDetachListener detach_listener;
    private LEDErrorListener error_listener;
    private JTextField attachedTxt;
    private JComboBox currentLimitCmb;
    private JLabel currentLimitLbl;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSlider ledBrightScrl;
    private JComboBox ledCmb;
    private JTextArea nameTxt;
    private JTextField numLEDTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JComboBox voltageCmb;
    private JLabel voltageLbl;

    public LED() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.attachedTxt = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.nameTxt = new JTextArea();
        this.jLabel2 = new JLabel();
        this.serialTxt = new JTextField();
        this.jLabel3 = new JLabel();
        this.versionTxt = new JTextField();
        this.jLabel4 = new JLabel();
        this.numLEDTxt = new JTextField();
        this.jLabel5 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel6 = new JLabel();
        this.ledCmb = new JComboBox();
        this.jLabel7 = new JLabel();
        this.ledBrightScrl = new JSlider();
        this.voltageCmb = new JComboBox();
        this.voltageLbl = new JLabel();
        this.currentLimitCmb = new JComboBox();
        this.currentLimitLbl = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("LED - full");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                LED.this.formWindowClosed(evt);
            }

            public void windowOpened(WindowEvent evt) {
                LED.this.formWindowOpened(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("LED Info"));
        this.attachedTxt.setEditable(false);
        this.jLabel1.setText("Attached:");
        this.nameTxt.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
        this.nameTxt.setColumns(20);
        this.nameTxt.setEditable(false);
        this.nameTxt.setLineWrap(true);
        this.nameTxt.setRows(3);
        this.nameTxt.setTabSize(2);
        this.nameTxt.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.nameTxt);
        this.jLabel2.setText("Name:");
        this.serialTxt.setEditable(false);
        this.jLabel3.setText("Serial No.:");
        this.versionTxt.setEditable(false);
        this.jLabel4.setText("Version:");
        this.numLEDTxt.setEditable(false);
        this.jLabel5.setText("# of LEDs:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(34, 34, 34).add(jPanel1Layout.createParallelGroup(2).add(this.jLabel1).add(this.jLabel2).add(this.jLabel3).add(this.jLabel4).add(this.jLabel5)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(2, false).add(1, this.numLEDTxt).add(1, this.versionTxt).add(1, this.serialTxt).add(1, this.attachedTxt).add(1, this.jScrollPane1)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(3).add(this.attachedTxt, -2, -1, -2).add(this.jLabel1)).add(15, 15, 15).add(jPanel1Layout.createParallelGroup(1).add(this.jScrollPane1, -2, -1, -2).add(this.jLabel2)).add(16, 16, 16).add(jPanel1Layout.createParallelGroup(3).add(this.serialTxt, -2, -1, -2).add(this.jLabel3)).add(16, 16, 16).add(jPanel1Layout.createParallelGroup(3).add(this.versionTxt, -2, -1, -2).add(this.jLabel4)).add(15, 15, 15).add(jPanel1Layout.createParallelGroup(3).add(this.numLEDTxt, -2, -1, -2).add(this.jLabel5)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("LED Control"));
        this.jLabel6.setText("LED Index:");
        this.ledCmb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LED.this.ledCmbActionPerformed(evt);
            }
        });
        this.jLabel7.setText("LED Brightness:");
        this.ledBrightScrl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                LED.this.ledBrightScrlStateChanged(evt);
            }
        });
        this.voltageCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"1.7V", "2.75V", "3.9V", "5.0V"}));
        this.voltageCmb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LED.this.voltageCmbActionPerformed(evt);
            }
        });
        this.voltageLbl.setText("Voltage:");
        this.currentLimitCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"20mA", "40mA", "60mA", "80mA"}));
        this.currentLimitCmb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LED.this.currentLimitCmbActionPerformed(evt);
            }
        });
        this.currentLimitLbl.setText("Current Limit:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(1, false).add(jPanel2Layout.createSequentialGroup().add(this.jLabel6).add(26, 26, 26).add(this.ledCmb, -2, 168, -2)).add(jPanel2Layout.createSequentialGroup().add(jPanel2Layout.createParallelGroup(1).add(this.jLabel7).add(this.voltageLbl).add(this.currentLimitLbl)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(1).add(this.voltageCmb, 0, 168, Short.MAX_VALUE).add(this.ledBrightScrl, 0, 0, Short.MAX_VALUE).add(this.currentLimitCmb, 0, 168, Short.MAX_VALUE)))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(3).add(this.jLabel6).add(this.ledCmb, -2, -1, -2)).add(25, 25, 25).add(jPanel2Layout.createParallelGroup(1).add(this.jLabel7).add(this.ledBrightScrl, -2, -1, -2)).addPreferredGap(1).add(jPanel2Layout.createParallelGroup(3).add(this.voltageCmb, -2, -1, -2).add(this.voltageLbl)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.currentLimitCmb, -2, -1, -2).add(this.currentLimitLbl)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.jPanel2, -2, -1, -2).add(this.jPanel1, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -2, -1, -2).addPreferredGap(0).add(this.jPanel2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.ledCmb.setEnabled(false);
        this.ledBrightScrl.setEnabled(false);
        this.ledBrightScrl.setMaximum(100);
        this.ledBrightScrl.setMinimum(0);
        try {
            this.led = new LEDPhidget();
            this.attach_listener = new LEDAttachListener(this, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numLEDTxt, this.ledCmb, this.ledBrightScrl, this.voltageCmb, this.currentLimitCmb, this.voltageLbl, this.currentLimitLbl);
            this.detach_listener = new LEDDetachListener(this, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numLEDTxt, this.ledCmb, this.ledBrightScrl, this.voltageCmb, this.currentLimitCmb, this.voltageLbl, this.currentLimitLbl);
            this.error_listener = new LEDErrorListener(this);
            this.led.addAttachListener(this.attach_listener);
            this.led.addDetachListener(this.detach_listener);
            this.led.addErrorListener(this.error_listener);
            if (runArgs.length > 1 && runArgs[1].equals("remote")) {
                this.led.open(Integer.parseInt(runArgs[0]), null);
            } else if (runArgs.length > 0) {
                this.led.open(Integer.parseInt(runArgs[0]));
            } else {
                this.led.openAny();
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void ledCmbActionPerformed(ActionEvent evt) {
        if (this.ledCmb.isEnabled() && this.ledBrightScrl.isEnabled()) {
            try {
                this.ledBrightScrl.setValue((int)this.led.getBrightness((Integer)this.ledCmb.getSelectedItem()));
            }
            catch (PhidgetException ex) {
                this.ledBrightScrl.setValue(0);
            }
        }
    }

    private void ledBrightScrlStateChanged(ChangeEvent evt) {
        if (this.ledBrightScrl.isEnabled()) {
            try {
                this.led.setBrightness((Integer)this.ledCmb.getSelectedItem(), this.ledBrightScrl.getValue());
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), 0);
            }
        }
    }

    private void formWindowClosed(WindowEvent evt) {
        try {
            this.led.removeErrorListener(this.error_listener);
            this.led.removeDetachListener(this.detach_listener);
            this.led.removeAttachListener(this.attach_listener);
            this.led.close();
            this.led = null;
            this.dispose();
            System.exit(0);
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), 0);
            this.dispose();
            System.exit(0);
        }
    }

    private void voltageCmbActionPerformed(ActionEvent evt) {
        try {
            if (this.voltageCmb.getSelectedItem().toString().equals("1.7V")) {
                this.led.setVoltage(1);
            } else if (this.voltageCmb.getSelectedItem().toString().equals("2.75V")) {
                this.led.setVoltage(2);
            } else if (this.voltageCmb.getSelectedItem().toString().equals("3.9V")) {
                this.led.setVoltage(3);
            } else if (this.voltageCmb.getSelectedItem().toString().equals("5.0V")) {
                this.led.setVoltage(4);
            }
        }
        catch (PhidgetException ex) {
            this.voltageCmb.setEnabled(false);
        }
    }

    private void currentLimitCmbActionPerformed(ActionEvent evt) {
        try {
            if (this.currentLimitCmb.getSelectedItem().toString().equals("1.7V")) {
                this.led.setCurrentLimit(1);
            } else if (this.currentLimitCmb.getSelectedItem().toString().equals("2.75V")) {
                this.led.setCurrentLimit(2);
            } else if (this.currentLimitCmb.getSelectedItem().toString().equals("3.9V")) {
                this.led.setCurrentLimit(3);
            } else if (this.currentLimitCmb.getSelectedItem().toString().equals("5.0V")) {
                this.led.setCurrentLimit(4);
            }
        }
        catch (PhidgetException ex) {
            this.currentLimitCmb.setEnabled(false);
        }
    }

    public static void main(String[] args) {
        runArgs = args;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new LED().setVisible(true);
            }
        });
    }
}

