/*
 * Decompiled with CFR 0.152.
 */
package listeners;

import com.phidgets.AnalogPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.AttachEvent;
import com.phidgets.event.AttachListener;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ANAttachListener
implements AttachListener {
    private JFrame appFrame;
    private JPanel channelPanel;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numChannelsTxt;
    private JCheckBox[] enabledArray;
    private JSlider[] voltageSliderArray;
    private JTextField[] voltageTxtArray;

    public ANAttachListener(JFrame appFrame, JPanel channelPanel, JTextField attachedTxt, JTextArea nameTxt, JTextField serialTxt, JTextField versionTxt, JTextField numChannelsTxt, JCheckBox[] enabledArray, JSlider[] voltageSliderArray, JTextField[] voltageTxtArray) {
        this.appFrame = appFrame;
        this.channelPanel = channelPanel;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numChannelsTxt = numChannelsTxt;
        this.enabledArray = enabledArray;
        this.voltageSliderArray = voltageSliderArray;
        this.voltageTxtArray = voltageTxtArray;
    }

    public void attached(AttachEvent an) {
        try {
            this.appFrame.setSize(357, 500);
            AnalogPhidget attached = (AnalogPhidget)an.getSource();
            this.attachedTxt.setText(Boolean.toString(attached.isAttached()));
            this.nameTxt.setText(attached.getDeviceName());
            this.serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            this.versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
            this.numChannelsTxt.setText(Integer.toString(attached.getOutputCount()));
            this.channelPanel.setEnabled(true);
            this.channelPanel.setVisible(true);
            for (int i = 0; i < attached.getOutputCount(); ++i) {
                this.enabledArray[i].setEnabled(true);
                this.enabledArray[i].setVisible(true);
                this.enabledArray[i].setSelected(attached.getEnabled(i));
                this.voltageSliderArray[i].setEnabled(true);
                this.voltageSliderArray[i].setVisible(true);
                this.voltageSliderArray[i].setMaximum((int)Math.floor(attached.getVoltageMax(i) * 100.0));
                this.voltageSliderArray[i].setMinimum((int)Math.ceil(attached.getVoltageMin(i)) * 100);
                this.voltageSliderArray[i].setValue((int)attached.getVoltage(i));
                this.voltageTxtArray[i].setEnabled(true);
                this.voltageTxtArray[i].setVisible(true);
                this.voltageTxtArray[i].setText(Double.toString(attached.getVoltage(i)));
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this.appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), 0);
        }
    }
}

