/*
 * Decompiled with CFR 0.152.
 */
package Analog;

import com.phidgets.AnalogPhidget;
import com.phidgets.PhidgetException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import listeners.ANAttachListener;
import listeners.ANDetachListener;
import listeners.ANErrorListener;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class Analog
extends JFrame {
    private static String[] runArgs;
    private AnalogPhidget an;
    private ANAttachListener attach_listener;
    private ANDetachListener detach_listener;
    private ANErrorListener error_listener;
    private JCheckBox[] enabledArray;
    private JSlider[] voltageSliderArray;
    private JTextField[] voltageTxtArray;
    private JTextField attachedTxt;
    private JLabel channelLabel0;
    private JLabel channelLabel1;
    private JLabel channelLabel2;
    private JLabel channelLabel3;
    private JPanel channelPanel;
    private JCheckBox enabledChk0;
    private JCheckBox enabledChk1;
    private JCheckBox enabledChk2;
    private JCheckBox enabledChk3;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextArea nameTxt;
    private JTextField numChannelsTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JSlider voltageSlider0;
    private JSlider voltageSlider1;
    private JSlider voltageSlider2;
    private JSlider voltageSlider3;
    private JTextField voltageTxt0;
    private JTextField voltageTxt1;
    private JTextField voltageTxt2;
    private JTextField voltageTxt3;

    public Analog() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.attachedTxt = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.nameTxt = new JTextArea();
        this.jLabel2 = new JLabel();
        this.serialTxt = new JTextField();
        this.jLabel3 = new JLabel();
        this.versionTxt = new JTextField();
        this.jLabel4 = new JLabel();
        this.numChannelsTxt = new JTextField();
        this.jLabel5 = new JLabel();
        this.channelPanel = new JPanel();
        this.channelLabel0 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.channelLabel1 = new JLabel();
        this.channelLabel2 = new JLabel();
        this.channelLabel3 = new JLabel();
        this.voltageSlider0 = new JSlider();
        this.voltageTxt0 = new JTextField();
        this.enabledChk0 = new JCheckBox();
        this.enabledChk1 = new JCheckBox();
        this.enabledChk2 = new JCheckBox();
        this.enabledChk3 = new JCheckBox();
        this.voltageSlider1 = new JSlider();
        this.voltageSlider2 = new JSlider();
        this.voltageSlider3 = new JSlider();
        this.voltageTxt1 = new JTextField();
        this.voltageTxt2 = new JTextField();
        this.voltageTxt3 = new JTextField();
        this.jLabel6 = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("PhidgetAnalog-full");
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent evt) {
                Analog.this.formWindowOpened(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Analog Info"));
        this.jPanel1.setLayout(new AbsoluteLayout());
        this.attachedTxt.setEditable(false);
        this.jPanel1.add((Component)this.attachedTxt, new AbsoluteConstraints(97, 33, 200, -1));
        this.jLabel1.setText("Attached:");
        this.jPanel1.add((Component)this.jLabel1, new AbsoluteConstraints(43, 36, -1, -1));
        this.nameTxt.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
        this.nameTxt.setColumns(20);
        this.nameTxt.setEditable(false);
        this.nameTxt.setLineWrap(true);
        this.nameTxt.setRows(3);
        this.nameTxt.setTabSize(2);
        this.nameTxt.setWrapStyleWord(true);
        this.nameTxt.setPreferredSize(new Dimension(200, 58));
        this.jScrollPane1.setViewportView(this.nameTxt);
        this.jPanel1.add((Component)this.jScrollPane1, new AbsoluteConstraints(97, 68, 200, -1));
        this.jLabel2.setText("Name:");
        this.jPanel1.add((Component)this.jLabel2, new AbsoluteConstraints(60, 68, -1, -1));
        this.serialTxt.setEditable(false);
        this.jPanel1.add((Component)this.serialTxt, new AbsoluteConstraints(97, 144, 200, -1));
        this.jLabel3.setText("Serial No:");
        this.jPanel1.add((Component)this.jLabel3, new AbsoluteConstraints(41, 147, -1, -1));
        this.versionTxt.setEditable(false);
        this.jPanel1.add((Component)this.versionTxt, new AbsoluteConstraints(97, 180, 200, -1));
        this.jLabel4.setText("Version:");
        this.jPanel1.add((Component)this.jLabel4, new AbsoluteConstraints(48, 180, -1, -1));
        this.numChannelsTxt.setEditable(false);
        this.jPanel1.add((Component)this.numChannelsTxt, new AbsoluteConstraints(97, 216, 200, -1));
        this.jLabel5.setText("# Channels:");
        this.jPanel1.add((Component)this.jLabel5, new AbsoluteConstraints(30, 220, -1, 20));
        this.channelPanel.setBorder(BorderFactory.createTitledBorder("Channel Output"));
        this.channelPanel.setLayout(new AbsoluteLayout());
        this.channelLabel0.setText("0");
        this.channelPanel.add((Component)this.channelLabel0, new AbsoluteConstraints(40, 60, -1, -1));
        this.jLabel7.setText("Voltage(V)");
        this.channelPanel.add((Component)this.jLabel7, new AbsoluteConstraints(210, 30, -1, -1));
        this.jLabel8.setText("Enabled");
        this.channelPanel.add((Component)this.jLabel8, new AbsoluteConstraints(90, 30, -1, -1));
        this.channelLabel1.setText("1");
        this.channelPanel.add((Component)this.channelLabel1, new AbsoluteConstraints(40, 90, -1, -1));
        this.channelLabel2.setText("2");
        this.channelPanel.add((Component)this.channelLabel2, new AbsoluteConstraints(40, 120, -1, -1));
        this.channelLabel3.setText("3");
        this.channelPanel.add((Component)this.channelLabel3, new AbsoluteConstraints(40, 150, -1, -1));
        this.voltageSlider0.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Analog.this.voltageSlider0StateChanged(evt);
            }
        });
        this.channelPanel.add((Component)this.voltageSlider0, new AbsoluteConstraints(135, 60, 110, -1));
        this.voltageTxt0.setEditable(false);
        this.channelPanel.add((Component)this.voltageTxt0, new AbsoluteConstraints(255, 60, 40, -1));
        this.enabledChk0.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Analog.this.enabledChk0ActionPerformed(evt);
            }
        });
        this.channelPanel.add((Component)this.enabledChk0, new AbsoluteConstraints(90, 60, -1, -1));
        this.enabledChk1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Analog.this.enabledChk1ActionPerformed(evt);
            }
        });
        this.channelPanel.add((Component)this.enabledChk1, new AbsoluteConstraints(90, 90, -1, -1));
        this.enabledChk2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Analog.this.enabledChk2ActionPerformed(evt);
            }
        });
        this.channelPanel.add((Component)this.enabledChk2, new AbsoluteConstraints(90, 120, -1, -1));
        this.enabledChk3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Analog.this.enabledChk3ActionPerformed(evt);
            }
        });
        this.channelPanel.add((Component)this.enabledChk3, new AbsoluteConstraints(90, 150, -1, -1));
        this.voltageSlider1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Analog.this.voltageSlider1StateChanged(evt);
            }
        });
        this.channelPanel.add((Component)this.voltageSlider1, new AbsoluteConstraints(135, 90, 110, -1));
        this.voltageSlider2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Analog.this.voltageSlider2StateChanged(evt);
            }
        });
        this.channelPanel.add((Component)this.voltageSlider2, new AbsoluteConstraints(135, 120, 110, -1));
        this.voltageSlider3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Analog.this.voltageSlider3StateChanged(evt);
            }
        });
        this.channelPanel.add((Component)this.voltageSlider3, new AbsoluteConstraints(135, 150, 110, -1));
        this.voltageTxt1.setEditable(false);
        this.channelPanel.add((Component)this.voltageTxt1, new AbsoluteConstraints(255, 90, 40, -1));
        this.voltageTxt2.setEditable(false);
        this.channelPanel.add((Component)this.voltageTxt2, new AbsoluteConstraints(255, 120, 40, -1));
        this.voltageTxt3.setEditable(false);
        this.channelPanel.add((Component)this.voltageTxt3, new AbsoluteConstraints(255, 150, 40, -1));
        this.jLabel6.setText("Channel #");
        this.channelPanel.add((Component)this.jLabel6, new AbsoluteConstraints(20, 30, -1, -1));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.channelPanel, GroupLayout.Alignment.LEADING, -1, 320, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -2, 320, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, 252, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.channelPanel, -2, 185, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.setSize(357, 311);
        this.channelPanel.setVisible(false);
        this.channelPanel.setEnabled(false);
        this.enabledArray = new JCheckBox[4];
        this.enabledArray[0] = this.enabledChk0;
        this.enabledArray[1] = this.enabledChk1;
        this.enabledArray[2] = this.enabledChk2;
        this.enabledArray[3] = this.enabledChk3;
        this.voltageSliderArray = new JSlider[4];
        this.voltageSliderArray[0] = this.voltageSlider0;
        this.voltageSliderArray[1] = this.voltageSlider1;
        this.voltageSliderArray[2] = this.voltageSlider2;
        this.voltageSliderArray[3] = this.voltageSlider3;
        this.voltageTxtArray = new JTextField[4];
        this.voltageTxtArray[0] = this.voltageTxt0;
        this.voltageTxtArray[1] = this.voltageTxt1;
        this.voltageTxtArray[2] = this.voltageTxt2;
        this.voltageTxtArray[3] = this.voltageTxt3;
        for (int i = 0; i < 4; ++i) {
            this.enabledArray[i].setVisible(false);
            this.enabledArray[i].setEnabled(false);
            this.voltageTxtArray[i].setVisible(false);
            this.voltageTxtArray[i].setEnabled(false);
            this.voltageSliderArray[i].setVisible(false);
            this.voltageSliderArray[i].setEnabled(false);
        }
        try {
            this.an = new AnalogPhidget();
            this.attach_listener = new ANAttachListener(this, this.channelPanel, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numChannelsTxt, this.enabledArray, this.voltageSliderArray, this.voltageTxtArray);
            this.detach_listener = new ANDetachListener(this, this.channelPanel, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numChannelsTxt, this.enabledArray, this.voltageSliderArray, this.voltageTxtArray);
            this.error_listener = new ANErrorListener(this);
            this.an.addAttachListener(this.attach_listener);
            this.an.addDetachListener(this.detach_listener);
            this.an.addErrorListener(this.error_listener);
            if (runArgs.length > 1 && runArgs[1].equals("remote")) {
                this.an.open(Integer.parseInt(runArgs[0]), null);
            }
            if (runArgs.length > 0) {
                this.an.open(Integer.parseInt(runArgs[0]));
            } else {
                this.an.openAny();
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void voltageSlider0StateChanged(ChangeEvent evt) {
        JSlider slider = (JSlider)evt.getSource();
        if (slider.isEnabled()) {
            try {
                this.an.setVoltage(0, (double)slider.getValue() / 100.0);
                this.voltageTxt0.setText(Double.toString((double)slider.getValue() / 100.0));
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            }
        }
    }

    private void enabledChk0ActionPerformed(ActionEvent evt) {
        JCheckBox chk = (JCheckBox)evt.getSource();
        try {
            if (chk.isEnabled()) {
                this.an.setEnabled(0, this.enabledChk0.isSelected());
                chk.setText("");
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void voltageSlider1StateChanged(ChangeEvent evt) {
        JSlider slider = (JSlider)evt.getSource();
        if (slider.isEnabled()) {
            try {
                this.an.setVoltage(1, (double)slider.getValue() / 100.0);
                this.voltageTxt1.setText(Double.toString((double)slider.getValue() / 100.0));
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            }
        }
    }

    private void voltageSlider2StateChanged(ChangeEvent evt) {
        JSlider slider = (JSlider)evt.getSource();
        if (slider.isEnabled()) {
            try {
                this.an.setVoltage(2, (double)slider.getValue() / 100.0);
                this.voltageTxt2.setText(Double.toString((double)slider.getValue() / 100.0));
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            }
        }
    }

    private void voltageSlider3StateChanged(ChangeEvent evt) {
        JSlider slider = (JSlider)evt.getSource();
        if (slider.isEnabled()) {
            try {
                this.an.setVoltage(3, (double)slider.getValue() / 100.0);
                this.voltageTxt3.setText(Double.toString((double)slider.getValue() / 100.0));
            }
            catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            }
        }
    }

    private void enabledChk1ActionPerformed(ActionEvent evt) {
        JCheckBox chk = (JCheckBox)evt.getSource();
        try {
            if (chk.isEnabled()) {
                this.an.setEnabled(1, this.enabledChk1.isSelected());
                chk.setText("");
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void enabledChk2ActionPerformed(ActionEvent evt) {
        JCheckBox chk = (JCheckBox)evt.getSource();
        try {
            if (chk.isEnabled()) {
                this.an.setEnabled(2, this.enabledChk2.isSelected());
                chk.setText("");
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void enabledChk3ActionPerformed(ActionEvent evt) {
        JCheckBox chk = (JCheckBox)evt.getSource();
        try {
            if (chk.isEnabled()) {
                this.an.setEnabled(3, this.enabledChk3.isSelected());
                chk.setText("");
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    public static void main(String[] args) {
        runArgs = args;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new Analog().setVisible(true);
            }
        });
    }
}

