/*
 * Decompiled with CFR 0.152.
 */
package listeners;

import com.phidgets.event.AccelerationChangeEvent;
import com.phidgets.event.AccelerationChangeListener;
import graphics.MotionGraphPanel;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class AccelChangeListener
implements AccelerationChangeListener {
    private JFrame appFrame;
    private MotionGraphPanel graphPanel;
    private JTextField accel1Txt;
    private JTextField accel2Txt;
    private JTextField accel3Txt;
    private double[] xFilt;
    private double[] yFilt;
    private double[] zFilt;
    private double xOut;
    private double yOut;
    private double zOut;

    public AccelChangeListener(JFrame appFrame, MotionGraphPanel graphPanel, JTextField accel1Txt, JTextField accel2Txt, JTextField accel3Txt) {
        this.appFrame = appFrame;
        this.graphPanel = graphPanel;
        this.accel1Txt = accel1Txt;
        this.accel2Txt = accel2Txt;
        this.accel3Txt = accel3Txt;
        this.xFilt = new double[7];
        this.yFilt = new double[7];
        this.zFilt = new double[7];
    }

    public void accelerationChanged(AccelerationChangeEvent ce) {
        int i = 0;
        switch (ce.getIndex()) {
            case 0: {
                this.xOut = 0.0;
                this.xFilt[6] = ce.getValue();
                for (i = 0; i < 6; ++i) {
                    this.xFilt[i] = this.xFilt[i + 1];
                    this.xOut += this.xFilt[i];
                }
                this.xOut /= 6.0;
                this.accel1Txt.setText(Double.toString(ce.getValue()));
                this.graphPanel.setXOut(this.xOut);
                break;
            }
            case 1: {
                this.yOut = 0.0;
                this.yFilt[6] = ce.getValue();
                for (i = 0; i < 6; ++i) {
                    this.yFilt[i] = this.yFilt[i + 1];
                    this.yOut += this.yFilt[i];
                }
                this.yOut /= 6.0;
                this.accel2Txt.setText(Double.toString(ce.getValue()));
                this.graphPanel.setYOut(this.yOut);
                break;
            }
            case 2: {
                this.zOut = 0.0;
                this.zFilt[6] = ce.getValue();
                for (i = 0; i < 6; ++i) {
                    this.zFilt[i] = this.zFilt[i + 1];
                    this.zOut += this.zFilt[i];
                }
                this.zOut /= 6.0;
                this.accel3Txt.setText(Double.toString(ce.getValue()));
                this.graphPanel.setZOut(this.zOut);
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this.appFrame, "Index " + ce.getIndex() + " is not a valid axis!", "Axis Index Error", 0);
            }
        }
        this.graphPanel.repaint();
    }
}

