/*
 * Decompiled with CFR 0.152.
 */
package Accelerometer;

import com.phidgets.AccelerometerPhidget;
import com.phidgets.PhidgetException;
import graphics.MotionGraphPanel;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import listeners.AccelAttachListener;
import listeners.AccelChangeListener;
import listeners.AccelDetachListener;
import listeners.AccelErrorListener;
import org.jdesktop.layout.GroupLayout;

public class Accelerometer
extends JFrame {
    private static String[] runArgs;
    private MotionGraphPanel graphPanel;
    private AccelerometerPhidget accel;
    private AccelAttachListener attach_listener;
    private AccelDetachListener detach_listener;
    private AccelErrorListener error_listener;
    private AccelChangeListener change_listener;
    private JTextField accel1Txt;
    private JTextField accel2Txt;
    private JTextField accel3Txt;
    private JTextField attachedTxt;
    private JSlider axis1SensitivityScrl;
    private JSlider axis2SensitivityScrl;
    private JSlider axis3SensitivityScrl;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JTextArea nameTxt;
    private JTextField numAxesTxt;
    private JTextField rangeTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;

    public Accelerometer() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.attachedTxt = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.nameTxt = new JTextArea();
        this.jLabel2 = new JLabel();
        this.serialTxt = new JTextField();
        this.jLabel3 = new JLabel();
        this.versionTxt = new JTextField();
        this.jLabel4 = new JLabel();
        this.numAxesTxt = new JTextField();
        this.jLabel5 = new JLabel();
        this.rangeTxt = new JTextField();
        this.jLabel12 = new JLabel();
        this.jPanel2 = new JPanel();
        this.accel1Txt = new JTextField();
        this.accel2Txt = new JTextField();
        this.accel3Txt = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.axis1SensitivityScrl = new JSlider();
        this.axis2SensitivityScrl = new JSlider();
        this.axis3SensitivityScrl = new JSlider();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("Accelerometer - full");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                Accelerometer.this.formWindowClosed(evt);
            }

            public void windowOpened(WindowEvent evt) {
                Accelerometer.this.formWindowOpened(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Accelerometer Info"));
        this.attachedTxt.setEditable(false);
        this.jLabel1.setText("Attached:");
        this.nameTxt.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
        this.nameTxt.setColumns(20);
        this.nameTxt.setEditable(false);
        this.nameTxt.setLineWrap(true);
        this.nameTxt.setRows(3);
        this.nameTxt.setTabSize(2);
        this.nameTxt.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.nameTxt);
        this.jLabel2.setText("Name:");
        this.serialTxt.setEditable(false);
        this.jLabel3.setText("Serial No.:");
        this.versionTxt.setEditable(false);
        this.jLabel4.setText("Version:");
        this.numAxesTxt.setEditable(false);
        this.jLabel5.setText("Axes:");
        this.rangeTxt.setEditable(false);
        this.jLabel12.setText("Range:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(1).add(this.jLabel2).add(this.jLabel1).add(this.jLabel3).add(this.jLabel4).add(this.jLabel5).add(this.jLabel12)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(1, false).add(this.rangeTxt).add(this.numAxesTxt).add(this.attachedTxt).add(this.jScrollPane1).add(this.versionTxt).add(this.serialTxt, -2, 98, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(3).add(this.attachedTxt, -2, -1, -2).add(this.jLabel1)).add(15, 15, 15).add(jPanel1Layout.createParallelGroup(1).add(this.jLabel2).add(jPanel1Layout.createSequentialGroup().add(this.jScrollPane1, -2, -1, -2).add(16, 16, 16).add(jPanel1Layout.createParallelGroup(3).add(this.serialTxt, -2, -1, -2).add(this.jLabel3)).add(16, 16, 16).add(jPanel1Layout.createParallelGroup(3).add(this.versionTxt, -2, -1, -2).add(this.jLabel4)).add(15, 15, 15).add(jPanel1Layout.createParallelGroup(3).add(this.numAxesTxt, -2, -1, -2).add(this.jLabel5)).add(18, 18, 18).add(jPanel1Layout.createParallelGroup(3).add(this.jLabel12).add(this.rangeTxt, -2, -1, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Acceleration Data"));
        this.accel1Txt.setEditable(false);
        this.accel2Txt.setEditable(false);
        this.accel3Txt.setEditable(false);
        this.jLabel6.setText("Axis 1:");
        this.jLabel7.setText("Axis 2:");
        this.jLabel8.setText("Axis 3:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(2, jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(2).add(jPanel2Layout.createSequentialGroup().add(this.jLabel8).addPreferredGap(0, 23, Short.MAX_VALUE).add(this.accel3Txt, -2, 167, -2)).add(jPanel2Layout.createSequentialGroup().add(this.jLabel7).add(23, 23, 23).add(this.accel2Txt, -2, 167, -2)).add(jPanel2Layout.createSequentialGroup().add(this.jLabel6).addPreferredGap(0, 23, Short.MAX_VALUE).add(this.accel1Txt, -2, 167, -2))).addContainerGap(86, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(3).add(this.accel1Txt, -2, -1, -2).add(this.jLabel6)).add(16, 16, 16).add(jPanel2Layout.createParallelGroup(3).add(this.accel2Txt, -2, -1, -2).add(this.jLabel7)).add(16, 16, 16).add(jPanel2Layout.createParallelGroup(3).add(this.accel3Txt, -2, -1, -2).add(this.jLabel8)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Sensitivity Settings"));
        this.jLabel9.setText("Axis 1:");
        this.jLabel10.setText("Axis 2:");
        this.jLabel11.setText("Axis 3:");
        this.axis1SensitivityScrl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Accelerometer.this.axis1SensitivityScrlStateChanged(evt);
            }
        });
        this.axis2SensitivityScrl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Accelerometer.this.axis2SensitivityScrlStateChanged(evt);
            }
        });
        this.axis3SensitivityScrl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Accelerometer.this.axis3SensitivityScrlStateChanged(evt);
            }
        });
        this.jLabel13.setText("jLabel13");
        this.jLabel14.setText("jLabel14");
        this.jLabel15.setText("jLabel15");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().addContainerGap().add(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().add(jPanel3Layout.createParallelGroup(1).add(this.jLabel9).add(this.jLabel13)).addPreferredGap(0).add(this.axis1SensitivityScrl, -2, 177, -2)).add(jPanel3Layout.createSequentialGroup().add(jPanel3Layout.createParallelGroup(1).add(this.jLabel14).add(this.jLabel10)).addPreferredGap(0).add(this.axis2SensitivityScrl, -2, 177, -2)).add(jPanel3Layout.createSequentialGroup().add(jPanel3Layout.createParallelGroup(1).add(this.jLabel11).add(this.jLabel15)).addPreferredGap(0).add(this.axis3SensitivityScrl, -2, 177, -2))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().addContainerGap().add(jPanel3Layout.createParallelGroup(1).add(this.axis1SensitivityScrl, -2, -1, -2).add(jPanel3Layout.createSequentialGroup().add(this.jLabel9).addPreferredGap(0).add(this.jLabel13))).addPreferredGap(1).add(jPanel3Layout.createParallelGroup(1).add(this.axis2SensitivityScrl, -2, -1, -2).add(jPanel3Layout.createSequentialGroup().add(this.jLabel10).addPreferredGap(0).add(this.jLabel14))).addPreferredGap(1).add(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().add(this.jLabel11).addPreferredGap(0).add(this.jLabel15)).add(this.axis3SensitivityScrl, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.jPanel1, -2, -1, -2).add(this.jPanel3, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add(this.jPanel2, -2, -1, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.jPanel1, -2, -1, -2).addPreferredGap(0).add(this.jPanel3, -2, -1, -2)).add(2, this.jPanel2, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.setupUI();
        this.axis1SensitivityScrl.setEnabled(false);
        this.axis1SensitivityScrl.setValueIsAdjusting(true);
        this.axis1SensitivityScrl.setMinimum(0);
        this.axis1SensitivityScrl.setMaximum(100);
        this.axis1SensitivityScrl.setValue(0);
        this.axis1SensitivityScrl.setValueIsAdjusting(false);
        this.jLabel13.setText("(0.0)");
        this.axis2SensitivityScrl.setEnabled(false);
        this.axis2SensitivityScrl.setValueIsAdjusting(true);
        this.axis2SensitivityScrl.setMinimum(0);
        this.axis2SensitivityScrl.setMaximum(100);
        this.axis2SensitivityScrl.setValue(0);
        this.axis2SensitivityScrl.setValueIsAdjusting(false);
        this.jLabel14.setText("(0.0)");
        this.axis3SensitivityScrl.setEnabled(false);
        this.axis3SensitivityScrl.setValueIsAdjusting(true);
        this.axis3SensitivityScrl.setMinimum(0);
        this.axis3SensitivityScrl.setMaximum(100);
        this.axis3SensitivityScrl.setValue(0);
        this.axis3SensitivityScrl.setValueIsAdjusting(false);
        this.jLabel15.setText("(0.0)");
        try {
            this.accel = new AccelerometerPhidget();
            this.attach_listener = new AccelAttachListener(this, this.graphPanel, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numAxesTxt, this.rangeTxt, this.axis1SensitivityScrl, this.axis2SensitivityScrl, this.axis3SensitivityScrl, this.jLabel13, this.jLabel14, this.jLabel15);
            this.detach_listener = new AccelDetachListener(this, this.graphPanel, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numAxesTxt, this.rangeTxt, this.accel1Txt, this.accel2Txt, this.accel3Txt, this.axis1SensitivityScrl, this.axis2SensitivityScrl, this.axis3SensitivityScrl, this.jLabel13, this.jLabel14, this.jLabel15);
            this.error_listener = new AccelErrorListener(this);
            this.change_listener = new AccelChangeListener(this, this.graphPanel, this.accel1Txt, this.accel2Txt, this.accel3Txt);
            this.accel.addAttachListener(this.attach_listener);
            this.accel.addDetachListener(this.detach_listener);
            this.accel.addErrorListener(this.error_listener);
            this.accel.addAccelerationChangeListener(this.change_listener);
            if (runArgs.length > 1 && runArgs[1].equals("remote")) {
                this.accel.open(Integer.parseInt(runArgs[0]), null);
            } else if (runArgs.length > 0) {
                this.accel.open(Integer.parseInt(runArgs[0]));
            } else {
                this.accel.openAny();
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void setupUI() {
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(this.jLabel2)).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(this.jLabel1)).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(this.jLabel3)).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(this.jLabel4)).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(this.jLabel5)).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(this.jLabel12))).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(1, false).add(this.rangeTxt).add(this.numAxesTxt).add(this.versionTxt).add(this.serialTxt).add(this.attachedTxt).add(this.jScrollPane1)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(3).add(this.attachedTxt, -2, -1, -2).add(this.jLabel1)).add(15, 15, 15).add(jPanel1Layout.createParallelGroup(1).add(this.jLabel2).add(jPanel1Layout.createSequentialGroup().add(this.jScrollPane1, -2, -1, -2).add(16, 16, 16).add(jPanel1Layout.createParallelGroup(3).add(this.serialTxt, -2, -1, -2).add(this.jLabel3)).add(16, 16, 16).add(jPanel1Layout.createParallelGroup(3).add(this.versionTxt, -2, -1, -2).add(this.jLabel4)).add(15, 15, 15).add(jPanel1Layout.createParallelGroup(3).add(this.numAxesTxt, -2, -1, -2).add(this.jLabel5)).add(18, 18, 18).add(jPanel1Layout.createParallelGroup(3).add(this.jLabel12).add(this.rangeTxt, -2, -1, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(2, jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(2).add(jPanel2Layout.createSequentialGroup().add(this.jLabel8).addPreferredGap(0, 23, Short.MAX_VALUE).add(this.accel3Txt, -2, 167, -2)).add(jPanel2Layout.createSequentialGroup().add(this.jLabel7).add(23, 23, 23).add(this.accel2Txt, -2, 167, -2)).add(jPanel2Layout.createSequentialGroup().add(this.jLabel6).addPreferredGap(0, 23, Short.MAX_VALUE).add(this.accel1Txt, -2, 167, -2).addPreferredGap(0))).addContainerGap(86, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(3).add(this.accel1Txt, -2, -1, -2).add(this.jLabel6)).add(16, 16, 16).add(jPanel2Layout.createParallelGroup(3).add(this.accel2Txt, -2, -1, -2).add(this.jLabel7)).add(16, 16, 16).add(jPanel2Layout.createParallelGroup(3).add(this.accel3Txt, -2, -1, -2).add(this.jLabel8)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().addContainerGap().add(jPanel3Layout.createParallelGroup(1).add(2, jPanel3Layout.createSequentialGroup().add(jPanel3Layout.createParallelGroup(1).add(this.jLabel9).add(this.jLabel13)).addPreferredGap(0).add(this.axis1SensitivityScrl, -2, 177, -2).add(0, 0, Short.MAX_VALUE)).add(jPanel3Layout.createSequentialGroup().add(jPanel3Layout.createParallelGroup(1).add(this.jLabel14).add(this.jLabel10)).addPreferredGap(0).add(this.axis2SensitivityScrl, -2, 177, -2).add(0, 0, Short.MAX_VALUE)).add(jPanel3Layout.createSequentialGroup().add(jPanel3Layout.createParallelGroup(1).add(this.jLabel11).add(this.jLabel15)).addPreferredGap(0).add(this.axis3SensitivityScrl, -2, 177, -2).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().addContainerGap().add(jPanel3Layout.createParallelGroup(1).add(this.axis1SensitivityScrl, -2, -1, -2).add(jPanel3Layout.createSequentialGroup().add(this.jLabel9).addPreferredGap(0).add(this.jLabel13))).addPreferredGap(1).add(jPanel3Layout.createParallelGroup(1).add(this.axis2SensitivityScrl, -2, -1, -2).add(jPanel3Layout.createSequentialGroup().add(this.jLabel10).addPreferredGap(0).add(this.jLabel14))).addPreferredGap(1).add(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().add(this.jLabel11).addPreferredGap(0).add(this.jLabel15)).add(this.axis3SensitivityScrl, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.graphPanel = new MotionGraphPanel();
        GroupLayout graphPanelLayout = new GroupLayout(this.graphPanel);
        this.graphPanel.setLayout(graphPanelLayout);
        graphPanelLayout.setHorizontalGroup(graphPanelLayout.createParallelGroup(1).add(0, 319, Short.MAX_VALUE));
        graphPanelLayout.setVerticalGroup(graphPanelLayout.createParallelGroup(1).add(0, 291, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.jPanel1, -2, -1, -2).add(this.jPanel3, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add(layout.createParallelGroup(1, false).add(this.jPanel2, -1, -1, Short.MAX_VALUE).add(this.graphPanel, -1, 331, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1, false).add(layout.createSequentialGroup().add(this.jPanel1, -2, -1, -2).addPreferredGap(0).add(this.jPanel3, -2, -1, -2)).add(layout.createSequentialGroup().add(this.graphPanel, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add(this.jPanel2, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void axis1SensitivityScrlStateChanged(ChangeEvent evt) {
        try {
            if (this.axis1SensitivityScrl.isEnabled() && (this.accel.isAttached() || this.accel.isAttachedToServer())) {
                double value = (double)this.axis1SensitivityScrl.getValue() / 100.0;
                this.accel.setAccelerationChangeTrigger(0, value);
                this.jLabel13.setText("(" + value + ")");
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void axis2SensitivityScrlStateChanged(ChangeEvent evt) {
        try {
            if (this.axis2SensitivityScrl.isEnabled() && (this.accel.isAttached() || this.accel.isAttachedToServer())) {
                double value = (double)this.axis2SensitivityScrl.getValue() / 100.0;
                this.accel.setAccelerationChangeTrigger(1, value);
                this.jLabel14.setText("(" + value + ")");
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void axis3SensitivityScrlStateChanged(ChangeEvent evt) {
        try {
            if (this.axis3SensitivityScrl.isEnabled() && (this.accel.isAttached() || this.accel.isAttachedToServer())) {
                double value = (double)this.axis3SensitivityScrl.getValue() / 100.0;
                this.accel.setAccelerationChangeTrigger(2, value);
                this.jLabel15.setText("(" + value + ")");
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void formWindowClosed(WindowEvent evt) {
        try {
            this.accel.removeAccelerationChangeListener(this.change_listener);
            this.accel.removeErrorListener(this.error_listener);
            this.accel.removeDetachListener(this.detach_listener);
            this.accel.removeAttachListener(this.attach_listener);
            this.accel.close();
            this.accel = null;
            this.dispose();
            System.exit(0);
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            this.dispose();
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        runArgs = args;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new Accelerometer().setVisible(true);
            }
        });
    }
}

