/*
 * Decompiled with CFR 0.152.
 */
package com.phidgets;

import com.phidgets.Phidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.OutputChangeEvent;
import com.phidgets.event.OutputChangeListener;
import com.phidgets.event.TagGainEvent;
import com.phidgets.event.TagGainListener;
import com.phidgets.event.TagLossEvent;
import com.phidgets.event.TagLossListener;
import java.util.Iterator;
import java.util.LinkedList;

public final class RFIDPhidget
extends Phidget {
    public static final int PHIDGET_RFID_PROTOCOL_EM4100 = 1;
    public static final int PHIDGET_RFID_PROTOCOL_ISO11785_FDX_B = 2;
    public static final int PHIDGET_RFID_PROTOCOL_PHIDGETS = 3;
    private LinkedList tagGainListeners = new LinkedList();
    private long nativeTagGainHandler = 0L;
    private LinkedList tagLossListeners = new LinkedList();
    private long nativeTagLossHandler = 0L;
    private LinkedList outputChangeListeners = new LinkedList();
    private long nativeOutputChangeHandler = 0L;

    public RFIDPhidget() throws PhidgetException {
        super(RFIDPhidget.create());
    }

    private static native long create() throws PhidgetException;

    public native int getOutputCount() throws PhidgetException;

    public native boolean getOutputState(int var1) throws PhidgetException;

    public native void setOutputState(int var1, boolean var2) throws PhidgetException;

    public native boolean getAntennaOn() throws PhidgetException;

    public native void setAntennaOn(boolean var1) throws PhidgetException;

    public native boolean getLEDOn() throws PhidgetException;

    public native void setLEDOn(boolean var1) throws PhidgetException;

    public native String getLastTag() throws PhidgetException;

    public native int getLastTagProtocol() throws PhidgetException;

    public native boolean getTagStatus() throws PhidgetException;

    public native void write(String var1, int var2, boolean var3) throws PhidgetException;

    private final void enableDeviceSpecificEvents(boolean bl) {
        this.enableTagGainEvents(bl && this.tagGainListeners.size() > 0);
        this.enableTagLossEvents(bl && this.tagLossListeners.size() > 0);
        this.enableOutputChangeEvents(bl && this.outputChangeListeners.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTagGainListener(TagGainListener tagGainListener) {
        LinkedList linkedList = this.tagGainListeners;
        synchronized (linkedList) {
            this.tagGainListeners.add(tagGainListener);
            this.enableTagGainEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeTagGainListener(TagGainListener tagGainListener) {
        LinkedList linkedList = this.tagGainListeners;
        synchronized (linkedList) {
            this.tagGainListeners.remove(tagGainListener);
            this.enableTagGainEvents(this.tagGainListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTagGain(TagGainEvent tagGainEvent) {
        LinkedList linkedList = this.tagGainListeners;
        synchronized (linkedList) {
            Iterator iterator = this.tagGainListeners.iterator();
            while (iterator.hasNext()) {
                ((TagGainListener)iterator.next()).tagGained(tagGainEvent);
            }
        }
    }

    private native void enableTagGainEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTagLossListener(TagLossListener tagLossListener) {
        LinkedList linkedList = this.tagLossListeners;
        synchronized (linkedList) {
            this.tagLossListeners.add(tagLossListener);
            this.enableTagLossEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeTagLossListener(TagLossListener tagLossListener) {
        LinkedList linkedList = this.tagLossListeners;
        synchronized (linkedList) {
            this.tagLossListeners.remove(tagLossListener);
            this.enableTagLossEvents(this.tagLossListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTagLoss(TagLossEvent tagLossEvent) {
        LinkedList linkedList = this.tagLossListeners;
        synchronized (linkedList) {
            Iterator iterator = this.tagLossListeners.iterator();
            while (iterator.hasNext()) {
                ((TagLossListener)iterator.next()).tagLost(tagLossEvent);
            }
        }
    }

    private native void enableTagLossEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addOutputChangeListener(OutputChangeListener outputChangeListener) {
        LinkedList linkedList = this.outputChangeListeners;
        synchronized (linkedList) {
            this.outputChangeListeners.add(outputChangeListener);
            this.enableOutputChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeOutputChangeListener(OutputChangeListener outputChangeListener) {
        LinkedList linkedList = this.outputChangeListeners;
        synchronized (linkedList) {
            this.outputChangeListeners.remove(outputChangeListener);
            this.enableOutputChangeEvents(this.outputChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireOutputChange(OutputChangeEvent outputChangeEvent) {
        LinkedList linkedList = this.outputChangeListeners;
        synchronized (linkedList) {
            Iterator iterator = this.outputChangeListeners.iterator();
            while (iterator.hasNext()) {
                ((OutputChangeListener)iterator.next()).outputChanged(outputChangeEvent);
            }
        }
    }

    private native void enableOutputChangeEvents(boolean var1);
}

