/*
 * Decompiled with CFR 0.152.
 */
package Stepper;

import com.phidgets.PhidgetException;
import com.phidgets.StepperPhidget;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import listeners.StepperAttachListener;
import listeners.StepperCurrentChangeListener;
import listeners.StepperDetachListener;
import listeners.StepperErrorListener;
import listeners.StepperInputChangeListener;
import listeners.StepperPositionListener;
import listeners.StepperVelocityListener;
import org.jdesktop.layout.GroupLayout;

public class Stepper
extends JFrame {
    private static String[] runArgs;
    private StepperPhidget stepper;
    private StepperAttachListener attach_listener;
    private StepperDetachListener detach_listener;
    private StepperErrorListener error_listener;
    private StepperCurrentChangeListener current_listener;
    private StepperInputChangeListener input_listener;
    private StepperPositionListener position_listener;
    private StepperVelocityListener velocity_listener;
    private JCheckBox[] inputArray;
    private JSlider accelScrl;
    private JTextField accelTxt;
    private JTextField attachedTxt;
    private JTextField currentActualTxt;
    private JSlider currentLimitScrl;
    private JTextField currentLimitTxt;
    private JSlider currentPosScrl;
    private JCheckBox engagedChk;
    private JCheckBox in0Chk;
    private JCheckBox in1Chk;
    private JCheckBox in2Chk;
    private JCheckBox in3Chk;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JComboBox motorCmb;
    private JTextArea nameTxt;
    private JTextField numMotorsTxt;
    private JTextField posActualTxt;
    private JTextField posTargetTxt;
    private JTextField serialTxt;
    private JCheckBox stoppedChk;
    private JSlider targetPosScrl;
    private JTextField velActualTxt;
    private JSlider velLimitScrl;
    private JTextField velLimitTxt;
    private JTextField versionTxt;

    public Stepper() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel6 = new JLabel();
        this.motorCmb = new JComboBox();
        this.jLabel7 = new JLabel();
        this.jLabel16 = new JLabel();
        this.velActualTxt = new JTextField();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.posTargetTxt = new JTextField();
        this.accelTxt = new JTextField();
        this.velLimitTxt = new JTextField();
        this.jLabel12 = new JLabel();
        this.currentLimitTxt = new JTextField();
        this.jLabel17 = new JLabel();
        this.jLabel18 = new JLabel();
        this.posActualTxt = new JTextField();
        this.currentActualTxt = new JTextField();
        this.engagedChk = new JCheckBox();
        this.stoppedChk = new JCheckBox();
        this.jLabel13 = new JLabel();
        this.velLimitScrl = new JSlider();
        this.jLabel14 = new JLabel();
        this.accelScrl = new JSlider();
        this.jLabel15 = new JLabel();
        this.targetPosScrl = new JSlider();
        this.jLabel10 = new JLabel();
        this.currentPosScrl = new JSlider();
        this.jLabel11 = new JLabel();
        this.currentLimitScrl = new JSlider();
        this.jPanel1 = new JPanel();
        this.attachedTxt = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.nameTxt = new JTextArea();
        this.jLabel2 = new JLabel();
        this.serialTxt = new JTextField();
        this.jLabel3 = new JLabel();
        this.versionTxt = new JTextField();
        this.jLabel4 = new JLabel();
        this.numMotorsTxt = new JTextField();
        this.jLabel5 = new JLabel();
        this.jPanel3 = new JPanel();
        this.in0Chk = new JCheckBox();
        this.in1Chk = new JCheckBox();
        this.in2Chk = new JCheckBox();
        this.in3Chk = new JCheckBox();
        this.setDefaultCloseOperation(3);
        this.setTitle("Stepper - full");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                Stepper.this.formWindowClosed(evt);
            }

            public void windowOpened(WindowEvent evt) {
                Stepper.this.formWindowOpened(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Motor Data"));
        this.jLabel6.setText("Choose Stepper Motor:");
        this.motorCmb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Stepper.this.motorCmbActionPerformed(evt);
            }
        });
        this.jLabel7.setText("Velocity Limit:");
        this.jLabel16.setText("Actual:");
        this.velActualTxt.setEditable(false);
        this.jLabel8.setText("Acceleration:");
        this.jLabel9.setText("Position Target:");
        this.posTargetTxt.setEditable(false);
        this.accelTxt.setEditable(false);
        this.velLimitTxt.setEditable(false);
        this.jLabel12.setText("Current Limit:");
        this.currentLimitTxt.setEditable(false);
        this.jLabel17.setText("Actual:");
        this.jLabel18.setText("Actual:");
        this.posActualTxt.setEditable(false);
        this.currentActualTxt.setEditable(false);
        this.engagedChk.setText("Engaged");
        this.engagedChk.setEnabled(false);
        this.engagedChk.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Stepper.this.engagedChkStateChanged(evt);
            }
        });
        this.stoppedChk.setSelected(true);
        this.stoppedChk.setText("Stopped");
        this.stoppedChk.setEnabled(false);
        this.jLabel13.setText("Velocity Limit:");
        this.velLimitScrl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Stepper.this.velLimitScrlStateChanged(evt);
            }
        });
        this.jLabel14.setText("Acceleration:");
        this.accelScrl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Stepper.this.accelScrlStateChanged(evt);
            }
        });
        this.jLabel15.setText("Target Position:");
        this.targetPosScrl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Stepper.this.targetPosScrlStateChanged(evt);
            }
        });
        this.jLabel10.setText("Current Position:");
        this.currentPosScrl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Stepper.this.currentPosScrlStateChanged(evt);
            }
        });
        this.jLabel11.setText("Current Limit:");
        this.currentLimitScrl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Stepper.this.currentLimitScrlStateChanged(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(60, 60, 60).add(this.jLabel6).add(6, 6, 6).add(this.motorCmb, -2, 91, -2)).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(1).add(this.jLabel9).add(this.jLabel8).add(this.jLabel7).add(this.jLabel12)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(this.velLimitTxt, -2, 100, -2).addPreferredGap(1).add(this.jLabel16).addPreferredGap(0).add(this.velActualTxt, -2, 100, -2)).add(this.accelTxt, -2, 100, -2).add(jPanel2Layout.createSequentialGroup().add(this.posTargetTxt, -2, 100, -2).addPreferredGap(1).add(this.jLabel17).addPreferredGap(0).add(this.posActualTxt, -2, 100, -2)).add(jPanel2Layout.createSequentialGroup().add(this.currentLimitTxt, -2, 100, -2).add(10, 10, 10).add(this.jLabel18).addPreferredGap(0).add(this.currentActualTxt, -2, 100, -2)).add(jPanel2Layout.createSequentialGroup().add(11, 11, 11).add(this.engagedChk).addPreferredGap(0).add(this.stoppedChk))).add(10, 10, 10)).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(this.jLabel13)).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(this.velLimitScrl, -1, 338, Short.MAX_VALUE)).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(this.jLabel14)).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(this.accelScrl, -1, 338, Short.MAX_VALUE)).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(this.jLabel15)).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(this.targetPosScrl, -1, 338, Short.MAX_VALUE)).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(this.jLabel10)).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(this.currentPosScrl, -1, 338, Short.MAX_VALUE)).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(this.jLabel11)).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(this.currentLimitScrl, -1, 338, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(jPanel2Layout.createParallelGroup(3).add(this.jLabel6).add(this.motorCmb, -2, -1, -2)).add(18, 18, 18).add(jPanel2Layout.createParallelGroup(3).add(this.velLimitTxt, -2, -1, -2).add(this.jLabel7).add(this.jLabel16).add(this.velActualTxt, -2, -1, -2)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.accelTxt, -2, -1, -2).add(this.jLabel8)).add(8, 8, 8).add(jPanel2Layout.createParallelGroup(3).add(this.jLabel9).add(this.posTargetTxt, -2, -1, -2).add(this.jLabel17).add(this.posActualTxt, -2, -1, -2)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.currentLimitTxt, -2, -1, -2).add(this.jLabel12).add(this.currentActualTxt, -2, -1, -2).add(this.jLabel18)).add(18, 18, 18).add(jPanel2Layout.createParallelGroup(3).add(this.engagedChk).add(this.stoppedChk)).addPreferredGap(1).add(this.jLabel13).addPreferredGap(0).add(this.velLimitScrl, -2, -1, -2).addPreferredGap(0).add(this.jLabel14).addPreferredGap(0).add(this.accelScrl, -2, -1, -2).addPreferredGap(0).add(this.jLabel15).addPreferredGap(0).add(this.targetPosScrl, -2, -1, -2).addPreferredGap(0).add(this.jLabel10).addPreferredGap(0).add(this.currentPosScrl, -2, -1, -2).addPreferredGap(0).add(this.jLabel11).addPreferredGap(0).add(this.currentLimitScrl, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Stepper Info"));
        this.attachedTxt.setEditable(false);
        this.jLabel1.setText("Attached:");
        this.nameTxt.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
        this.nameTxt.setColumns(20);
        this.nameTxt.setEditable(false);
        this.nameTxt.setLineWrap(true);
        this.nameTxt.setRows(3);
        this.nameTxt.setTabSize(2);
        this.nameTxt.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.nameTxt);
        this.jLabel2.setText("Name:");
        this.serialTxt.setEditable(false);
        this.jLabel3.setText("Serial No.:");
        this.versionTxt.setEditable(false);
        this.jLabel4.setText("Version:");
        this.numMotorsTxt.setEditable(false);
        this.jLabel5.setText("# Steppers:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(35, 35, 35).add(jPanel1Layout.createParallelGroup(2).add(this.jLabel1).add(this.jLabel2).add(this.jLabel4).add(this.jLabel3).add(this.jLabel5)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(2, false).add(1, this.numMotorsTxt).add(1, this.versionTxt).add(1, this.serialTxt).add(1, this.jScrollPane1).add(1, this.attachedTxt, -1, 215, Short.MAX_VALUE)).addContainerGap(46, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(3).add(this.jLabel1).add(this.attachedTxt, -2, -1, -2)).add(15, 15, 15).add(jPanel1Layout.createParallelGroup(1).add(this.jScrollPane1, -2, -1, -2).add(this.jLabel2)).add(16, 16, 16).add(jPanel1Layout.createParallelGroup(3).add(this.serialTxt, -2, -1, -2).add(this.jLabel3)).add(16, 16, 16).add(jPanel1Layout.createParallelGroup(3).add(this.versionTxt, -2, -1, -2).add(this.jLabel4)).add(15, 15, 15).add(jPanel1Layout.createParallelGroup(3).add(this.numMotorsTxt, -2, -1, -2).add(this.jLabel5)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Input Data"));
        this.jPanel3.setMaximumSize(new Dimension(249, 51));
        this.in0Chk.setText("Input 0");
        this.in0Chk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.in0Chk.setMargin(new Insets(0, 0, 0, 0));
        this.in1Chk.setText("Input 1");
        this.in1Chk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.in1Chk.setMargin(new Insets(0, 0, 0, 0));
        this.in2Chk.setText("Input 2");
        this.in2Chk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.in2Chk.setMargin(new Insets(0, 0, 0, 0));
        this.in3Chk.setText("Input 3");
        this.in3Chk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.in3Chk.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().add(53, 53, 53).add(this.in0Chk).addPreferredGap(0).add(this.in1Chk).addPreferredGap(0).add(this.in2Chk).addPreferredGap(0).add(this.in3Chk).addContainerGap(75, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().addContainerGap().add(jPanel3Layout.createParallelGroup(3).add(this.in0Chk).add(this.in1Chk).add(this.in2Chk).add(this.in3Chk)).addContainerGap(23, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(2, false).add(1, this.jPanel1, -1, -1, Short.MAX_VALUE).add(1, this.jPanel3, -1, -1, Short.MAX_VALUE).add(1, this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -2, -1, -2).addPreferredGap(0).add(this.jPanel2, -2, -1, -2).addPreferredGap(0).add(this.jPanel3, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.inputArray = new JCheckBox[4];
        this.inputArray[0] = this.in0Chk;
        this.inputArray[1] = this.in1Chk;
        this.inputArray[2] = this.in2Chk;
        this.inputArray[3] = this.in3Chk;
        for (int i = 0; i < 4; ++i) {
            this.inputArray[i].setVisible(false);
            this.inputArray[i].setEnabled(false);
        }
        this.motorCmb.setEnabled(false);
        this.velLimitScrl.setEnabled(false);
        this.accelScrl.setEnabled(false);
        this.targetPosScrl.setEnabled(false);
        this.currentPosScrl.setEnabled(false);
        this.jLabel12.setVisible(false);
        this.currentLimitTxt.setVisible(false);
        this.jLabel18.setVisible(false);
        this.currentActualTxt.setVisible(false);
        this.jLabel11.setVisible(false);
        this.currentLimitScrl.setVisible(false);
        this.currentLimitScrl.setEnabled(false);
        try {
            this.stepper = new StepperPhidget();
            this.attach_listener = new StepperAttachListener(this, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numMotorsTxt, this.motorCmb, this.velLimitTxt, this.velActualTxt, this.accelTxt, this.posTargetTxt, this.posActualTxt, this.currentLimitTxt, this.currentActualTxt, this.velLimitScrl, this.accelScrl, this.targetPosScrl, this.currentPosScrl, this.currentLimitScrl, this.inputArray, this.jLabel11, this.jLabel12, this.jLabel18, this.engagedChk, this.stoppedChk);
            this.detach_listener = new StepperDetachListener(this, this.attachedTxt, this.nameTxt, this.serialTxt, this.versionTxt, this.numMotorsTxt, this.motorCmb, this.velLimitTxt, this.velActualTxt, this.accelTxt, this.posTargetTxt, this.posActualTxt, this.currentLimitTxt, this.currentActualTxt, this.velLimitScrl, this.accelScrl, this.targetPosScrl, this.currentPosScrl, this.currentLimitScrl, this.inputArray, this.jLabel11, this.jLabel12, this.jLabel18, this.engagedChk, this.stoppedChk);
            this.error_listener = new StepperErrorListener(this);
            this.current_listener = new StepperCurrentChangeListener(this.motorCmb, this.currentLimitTxt);
            this.input_listener = new StepperInputChangeListener(this.inputArray);
            this.position_listener = new StepperPositionListener(this, this.motorCmb, this.posActualTxt, this.stoppedChk, this.currentPosScrl);
            this.velocity_listener = new StepperVelocityListener(this, this.motorCmb, this.velActualTxt, this.stoppedChk, this.currentPosScrl);
            this.stepper.addAttachListener(this.attach_listener);
            this.stepper.addDetachListener(this.detach_listener);
            this.stepper.addErrorListener(this.error_listener);
            this.stepper.addCurrentChangeListener(this.current_listener);
            this.stepper.addInputChangeListener(this.input_listener);
            this.stepper.addStepperPositionChangeListener(this.position_listener);
            this.stepper.addStepperVelocityChangeListener(this.velocity_listener);
            if (runArgs.length > 1 && runArgs[1].equals("remote")) {
                this.stepper.open(Integer.parseInt(runArgs[0]), null);
            } else if (runArgs.length > 0) {
                this.stepper.open(Integer.parseInt(runArgs[0]));
            } else {
                this.stepper.openAny();
            }
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
        }
    }

    private void motorCmbActionPerformed(ActionEvent evt) {
        if (this.motorCmb.isEnabled()) {
            try {
                if (this.stepper.isAttached() || this.stepper.isAttachedToServer()) {
                    this.targetPosScrl.setValueIsAdjusting(true);
                    this.targetPosScrl.setValue((int)this.stepper.getTargetPosition((Integer)this.motorCmb.getSelectedItem()));
                    this.targetPosScrl.setValueIsAdjusting(false);
                    this.posTargetTxt.setText(Long.toString(this.stepper.getTargetPosition((Integer)this.motorCmb.getSelectedItem())));
                }
            }
            catch (PhidgetException ex) {
                this.targetPosScrl.setValueIsAdjusting(true);
                this.targetPosScrl.setValue(0);
                this.targetPosScrl.setValueIsAdjusting(false);
                this.posTargetTxt.setText("");
            }
            try {
                if (this.stepper.isAttached() || this.stepper.isAttachedToServer()) {
                    this.currentPosScrl.setValueIsAdjusting(true);
                    this.currentPosScrl.setValue((int)this.stepper.getCurrentPosition((Integer)this.motorCmb.getSelectedItem()));
                    this.currentPosScrl.setValueIsAdjusting(false);
                    this.posActualTxt.setText(Long.toString(this.stepper.getCurrentPosition((Integer)this.motorCmb.getSelectedItem())));
                }
            }
            catch (PhidgetException ex) {
                this.currentPosScrl.setValueIsAdjusting(true);
                this.currentPosScrl.setValue(0);
                this.currentPosScrl.setValueIsAdjusting(false);
                this.posActualTxt.setText("");
            }
            try {
                if (this.stepper.isAttached() || this.stepper.isAttachedToServer()) {
                    this.velLimitScrl.setValueIsAdjusting(true);
                    this.velLimitScrl.setValue((int)this.stepper.getVelocityLimit((Integer)this.motorCmb.getSelectedItem()));
                    this.velLimitScrl.setValueIsAdjusting(false);
                    this.velLimitTxt.setText(Double.toString(this.stepper.getVelocityLimit((Integer)this.motorCmb.getSelectedItem())));
                }
            }
            catch (PhidgetException ex) {
                this.velLimitScrl.setValueIsAdjusting(true);
                this.velLimitScrl.setValue(this.velLimitScrl.getMinimum());
                this.velLimitScrl.setValueIsAdjusting(false);
                this.velLimitTxt.setText("");
            }
            try {
                if (this.stepper.isAttached() || this.stepper.isAttachedToServer()) {
                    this.accelTxt.setText(Double.toString(this.stepper.getAcceleration((Integer)this.motorCmb.getSelectedItem())));
                    this.accelScrl.setValueIsAdjusting(true);
                    this.accelScrl.setValue((int)this.stepper.getAcceleration((Integer)this.motorCmb.getSelectedItem()));
                    this.accelScrl.setValueIsAdjusting(false);
                }
            }
            catch (PhidgetException ex) {
                this.accelScrl.setValueIsAdjusting(true);
                this.accelScrl.setValue(this.accelScrl.getMinimum());
                this.accelScrl.setValueIsAdjusting(false);
                this.accelTxt.setText("");
            }
            try {
                if (this.stepper.isAttached() || this.stepper.isAttachedToServer()) {
                    this.velActualTxt.setText(Double.toString(this.stepper.getVelocity((Integer)this.motorCmb.getSelectedItem())));
                }
            }
            catch (PhidgetException ex) {
                this.velActualTxt.setText("");
            }
            try {
                if (this.stepper.isAttached() || this.stepper.isAttachedToServer()) {
                    this.currentActualTxt.setText(Double.toString(this.stepper.getCurrent((Integer)this.motorCmb.getSelectedItem())));
                }
            }
            catch (PhidgetException ex) {
                this.currentActualTxt.setText("");
            }
            try {
                if (this.stepper.isAttached() || this.stepper.isAttachedToServer()) {
                    this.stoppedChk.setSelected(this.stepper.getStopped((Integer)this.motorCmb.getSelectedItem()));
                    this.currentPosScrl.setEnabled(this.stepper.getStopped((Integer)this.motorCmb.getSelectedItem()));
                }
            }
            catch (PhidgetException ex) {
                this.stoppedChk.setSelected(false);
                this.currentPosScrl.setEnabled(false);
            }
            try {
                if (this.stepper.isAttached() || this.stepper.isAttachedToServer()) {
                    this.engagedChk.setSelected(this.stepper.getEngaged((Integer)this.motorCmb.getSelectedItem()));
                }
            }
            catch (PhidgetException ex) {
                this.engagedChk.setSelected(false);
            }
            this.currentLimitTxt.setText("");
            this.currentLimitScrl.setValueIsAdjusting(true);
            this.currentLimitScrl.setValue(this.currentLimitScrl.getMinimum());
            this.currentLimitScrl.setValueIsAdjusting(false);
        }
    }

    private void velLimitScrlStateChanged(ChangeEvent evt) {
        if (this.velLimitScrl.isEnabled()) {
            try {
                if (this.stepper.isAttached() || this.stepper.isAttachedToServer()) {
                    double vel = this.velLimitScrl.getValue();
                    if (vel < this.stepper.getVelocityMin((Integer)this.motorCmb.getSelectedItem())) {
                        vel = this.stepper.getVelocityMin((Integer)this.motorCmb.getSelectedItem());
                    }
                    if (vel > this.stepper.getVelocityMax((Integer)this.motorCmb.getSelectedItem())) {
                        vel = this.stepper.getVelocityMax((Integer)this.motorCmb.getSelectedItem());
                    }
                    this.stepper.setVelocityLimit((Integer)this.motorCmb.getSelectedItem(), vel);
                    this.velLimitTxt.setText(Double.toString(this.stepper.getVelocityLimit((Integer)this.motorCmb.getSelectedItem())));
                }
            }
            catch (PhidgetException ex) {
                this.velLimitTxt.setText("Err");
            }
        }
    }

    private void accelScrlStateChanged(ChangeEvent evt) {
        if (this.accelScrl.isEnabled()) {
            try {
                if (this.stepper.isAttached() || this.stepper.isAttachedToServer()) {
                    double accel = this.accelScrl.getValue();
                    if (accel < this.stepper.getAccelerationMin((Integer)this.motorCmb.getSelectedItem())) {
                        accel = this.stepper.getAccelerationMin((Integer)this.motorCmb.getSelectedItem());
                    }
                    if (accel > this.stepper.getAccelerationMax((Integer)this.motorCmb.getSelectedItem())) {
                        accel = this.stepper.getAccelerationMax((Integer)this.motorCmb.getSelectedItem());
                    }
                    this.stepper.setAcceleration((Integer)this.motorCmb.getSelectedItem(), accel);
                    this.accelTxt.setText(Double.toString(this.stepper.getAcceleration((Integer)this.motorCmb.getSelectedItem())));
                }
            }
            catch (PhidgetException ex) {
                this.accelTxt.setText("Err");
            }
        }
    }

    private void targetPosScrlStateChanged(ChangeEvent evt) {
        if (this.targetPosScrl.isEnabled()) {
            try {
                if (this.stepper.isAttached() || this.stepper.isAttachedToServer()) {
                    this.stepper.setTargetPosition((Integer)this.motorCmb.getSelectedItem(), this.targetPosScrl.getValue());
                    this.posTargetTxt.setText(Long.toString(this.stepper.getTargetPosition((Integer)this.motorCmb.getSelectedItem())));
                }
            }
            catch (PhidgetException ex) {
                this.posTargetTxt.setText("Err");
            }
        }
    }

    private void formWindowClosed(WindowEvent evt) {
        try {
            this.stepper.removeAttachListener(this.attach_listener);
            this.stepper.removeDetachListener(this.detach_listener);
            this.stepper.removeErrorListener(this.error_listener);
            this.stepper.removeCurrentChangeListener(this.current_listener);
            this.stepper.removeInputChangeListener(this.input_listener);
            this.stepper.removeStepperPositionChangeListener(this.position_listener);
            this.stepper.removeStepperVelocityChangeListener(this.velocity_listener);
            if (this.stepper.isAttached()) {
                for (int i = 0; i < this.stepper.getMotorCount(); ++i) {
                    this.stepper.setEngaged(i, false);
                }
            }
            this.stepper.close();
            this.stepper = null;
            this.dispose();
            System.exit(0);
        }
        catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), 0);
            this.dispose();
            System.exit(0);
        }
    }

    private void engagedChkStateChanged(ChangeEvent evt) {
        if (this.engagedChk.isEnabled()) {
            try {
                if (this.stepper.isAttached() || this.stepper.isAttachedToServer()) {
                    this.stepper.setEngaged((Integer)this.motorCmb.getSelectedItem(), this.engagedChk.isSelected());
                }
            }
            catch (PhidgetException phidgetException) {
                // empty catch block
            }
        }
    }

    private void currentPosScrlStateChanged(ChangeEvent evt) {
        if (this.currentPosScrl.isEnabled()) {
            try {
                if (this.stepper.isAttached() || this.stepper.isAttachedToServer()) {
                    this.stepper.setCurrentPosition((Integer)this.motorCmb.getSelectedItem(), this.currentPosScrl.getValue());
                    this.posTargetTxt.setText(Integer.toString(this.currentPosScrl.getValue()));
                }
            }
            catch (PhidgetException ex) {
                this.posTargetTxt.setText("Err");
            }
        }
    }

    private void currentLimitScrlStateChanged(ChangeEvent evt) {
        if (this.currentLimitScrl.isEnabled()) {
            try {
                if (this.stepper.isAttached() || this.stepper.isAttachedToServer()) {
                    double current = (double)this.currentLimitScrl.getValue() / 100.0;
                    if (current < this.stepper.getCurrentMin((Integer)this.motorCmb.getSelectedItem())) {
                        current = this.stepper.getCurrentMin((Integer)this.motorCmb.getSelectedItem());
                    }
                    if (current > this.stepper.getCurrentMax((Integer)this.motorCmb.getSelectedItem())) {
                        current = this.stepper.getCurrentMax((Integer)this.motorCmb.getSelectedItem());
                    }
                    this.stepper.setCurrentLimit((Integer)this.motorCmb.getSelectedItem(), current);
                    this.currentLimitTxt.setText(Double.toString(this.stepper.getCurrentLimit((Integer)this.motorCmb.getSelectedItem())));
                }
            }
            catch (PhidgetException ex) {
                this.currentLimitTxt.setText("Err");
            }
        }
    }

    public static void main(String[] args) {
        runArgs = args;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new Stepper().setVisible(true);
            }
        });
    }
}

